#include <RCSwitch.h>
#include "PinDefinitionsAndMore.h"
#include <IRremote.h>

RCSwitch mySwitch = RCSwitch();
long int keycode=0;


void setup() 
{
  Serial.begin(9600);
  Serial1.begin(38400);
  mySwitch.enableReceive(digitalPinToInterrupt(13)); 

  IrReceiver.begin(IR_RECEIVE_PIN, ENABLE_LED_FEEDBACK, USE_DEFAULT_FEEDBACK_LED_PIN);
}

void loop() {
  if (mySwitch.available()) {
    
    Serial.print("Received ");
    Serial.print( mySwitch.getReceivedValue() );
    Serial.print(" / ");
    Serial.print( mySwitch.getReceivedBitlength() );
    Serial.print("bit ");
    Serial.print("Protocol: ");
    Serial.println( mySwitch.getReceivedProtocol() );
    keycode=mySwitch.getReceivedValue();

    if (keycode==4027064) {Serial1.print("RELAY-KEY-255,1,1");delay(500);}  //toggle relay1
    if (keycode==5575948) {Serial1.print("RELAY-KEY-255,2,1");delay(500);}  //toggle relay2
    if (keycode==5575984) {Serial1.print("RELAY-KEY-255,3,1");delay(500);}  //toggle relay3
    if (keycode==5576140) {Serial1.print("RELAY-KEY-255,4,1");delay(500);}  //toggle relay4
    if (keycode==5576143) {Serial1.print("RELAY-KEY-255,5,1");delay(500);}  //toggle relay5
    if (keycode==5575996) {Serial1.print("RELAY-KEY-255,6,1");delay(500);}  //toggle relay6
    if (keycode==5575999) {Serial1.print("RELAY-KEY-255,7,1");delay(500);}  //toggle relay7
    if (keycode==5576176) {Serial1.print("RELAY-KEY-255,8,1");delay(500);}  //toggle relay8
    if (keycode==5576131) {Serial1.print("RELAY-KEY-255,9,1");delay(500);}  //toggle relay9
    if (keycode==5575951) {Serial1.print("RELAY-KEY-255,10,1");delay(500);}  //toggle relay10
    if (keycode==5576188) {Serial1.print("RELAY-KEY-255,11,1");delay(500);}  //toggle relay11
    if (keycode==5576179) {Serial1.print("RELAY-KEY-255,12,1");delay(500);}  //toggle relay12
    if (keycode==5576191) {Serial1.print("RELAY-KEY-255,13,1");delay(500);}  //toggle relay13
    if (keycode==5576128) {Serial1.print("RELAY-KEY-255,14,1");delay(500);}  //toggle relay14
    if (keycode==5575987) {Serial1.print("RELAY-KEY-255,15,1");delay(500);}  //toggle relay15
    if (keycode==5575936) {Serial1.print("RELAY-KEY-255,16,1");delay(500);}  //toggle relay16
 
    mySwitch.resetAvailable();
  }

    if (IrReceiver.decode()) {

        // Print a short summary of received data
        IrReceiver.printIRResultShort(&Serial);
        if (IrReceiver.decodedIRData.protocol == UNKNOWN) {
            // We have an unknown protocol here, print more info
            IrReceiver.printIRResultRawFormatted(&Serial, true);
        }
        Serial.println();
        IrReceiver.resume(); // Enable receiving of the next value
    
    if (IrReceiver.decodedIRData.command == 0x15) Serial1.print("RELAY-SET-255,1,1"); //turn ON relay1
    if (IrReceiver.decodedIRData.command == 0x16) Serial1.print("RELAY-SET-255,1,0"); //turn OFF relay1
    if (IrReceiver.decodedIRData.command == 0x17) Serial1.print("RELAY-SET-255,2,1"); //turn ON relay2
    if (IrReceiver.decodedIRData.command == 0x19) Serial1.print("RELAY-SET-255,2,0"); //turn OFF relay2
    if (IrReceiver.decodedIRData.command == 0x1A) Serial1.print("RELAY-SET-255,3,1"); //turn ON relay3
    if (IrReceiver.decodedIRData.command == 0x1B) Serial1.print("RELAY-SET-255,3,0"); //turn OFF relay3
    if (IrReceiver.decodedIRData.command == 0x1D) Serial1.print("RELAY-SET-255,4,1"); //turn ON relay4
    if (IrReceiver.decodedIRData.command == 0x1E) Serial1.print("RELAY-SET-255,4,0"); //turn OFF relay4
    if (IrReceiver.decodedIRData.command == 0x1F) Serial1.print("RELAY-SET-255,5,1"); //turn ON relay5
    if (IrReceiver.decodedIRData.command == 0x41) Serial1.print("RELAY-SET-255,5,0"); //turn OFF relay5
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,6,1"); //turn OFF relay6
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,6,0"); //turn OFF relay6
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,7,1"); //turn OFF relay7
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,7,0"); //turn OFF relay7
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,8,1"); //turn OFF relay8
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,8,0"); //turn OFF relay8
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,9,1"); //turn OFF relay9
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,9,0"); //turn OFF relay9
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,10,1"); //turn OFF relay10
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,10,0"); //turn OFF relay10
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,11,1"); //turn OFF relay11
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,11,0"); //turn OFF relay11
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,12,1"); //turn OFF relay12
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,12,0"); //turn OFF relay12
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,13,1"); //turn OFF relay13
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,13,0"); //turn OFF relay13
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,14,1"); //turn OFF relay14
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,14,0"); //turn OFF relay14
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,15,1"); //turn OFF relay15
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,15,0"); //turn OFF relay15
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,16,1"); //turn OFF relay16
    if (IrReceiver.decodedIRData.command == 0x42) Serial1.print("RELAY-SET-255,16,0"); //turn OFF relay16
    } 
}
