/**********KC868-E16t-完整版测试程序************************/
/*功能描述
 * 上电后，RS485输出KinCony ACBDEFG命令                             //开始进行测试环节
 * 按输入端按键，继电器对应动作，                                     //输入端功能测试
 * 按无线433M遥控器，打印接收到的数据，                               //无线接收测试
 * 通过UDP软件发送任意数据，有返回即正常，                              //网口功能测试
 * 485发送任意数据，有返回即正常，波特率9600bps                       //485接收功能测试
 * 按download按键，蜂鸣器会鸣音                                     //蜂鸣器测试
 * 涂鸦模块测试:按一下tuya模块上方的按键，大约几秒后，按键下方的红色LED灯开始闪烁，则tuya模块正常工作。
 * 如需使用tuya app，则配网完成后可以直接控制继电器 (*生产操作无需执行此步骤)
************************/
#include "EEPROM.h"
#include <ETH.h> 
#include <WiFiUdp.h> 
#include "Arduino.h"
#include "PCF8574.h"
#include <RCSwitch.h>  

#include <TuyaWifi.h>

TuyaWifi my_device;

unsigned char pid[] = {"tfj1dtlneyxp5uya"};
unsigned char mcu_ver[] = {"1.0.0"};

/* Data point define */

#define DPID_SWITCH_1   1
#define DPID_SWITCH_2   2
#define DPID_SWITCH_3   3
#define DPID_SWITCH_4   4
#define DPID_SWITCH_5   5
#define DPID_SWITCH_6   6
#define DPID_SWITCH7   101
#define DPID_SWITCH8   102
#define DPID_SWITCH9   103
#define DPID_SWITCH10  104
#define DPID_SWITCH11  105
#define DPID_SWITCH12  106
#define DPID_SWITCH13  107
#define DPID_SWITCH14  108
#define DPID_SWITCH15  109
#define DPID_SWITCH16  110

unsigned char switch_1_state = 0;
unsigned char switch_2_state = 0;
unsigned char switch_3_state = 0;
unsigned char switch_4_state = 0;
unsigned char switch_5_state = 0;
unsigned char switch_6_state = 0;

unsigned char input_1_state = 0;
unsigned char input_2_state = 0;
unsigned char input_3_state = 0;
unsigned char input_4_state = 0;
unsigned char input_5_state = 0;
unsigned char input_6_state = 0;

unsigned char switch_7_state = 0;
unsigned char switch_8_state = 0;
unsigned char switch_9_state = 0;
unsigned char switch_10_state = 0;
unsigned char switch_11_state = 0;
unsigned char switch_12_state = 0;
unsigned char switch_13_state = 0;
unsigned char switch_14_state = 0;
unsigned char switch_15_state = 0;
unsigned char switch_16_state = 0;

/* Current  status */
unsigned char led_state = 0;

#define LED_WiFi  12
int key_pin = 5;

unsigned char dp_array[][2] =
{
  {DPID_SWITCH_1, DP_TYPE_BOOL},{DPID_SWITCH_2, DP_TYPE_BOOL},{DPID_SWITCH_3, DP_TYPE_BOOL},{DPID_SWITCH_4, DP_TYPE_BOOL},{DPID_SWITCH_5, DP_TYPE_BOOL},{DPID_SWITCH_6, DP_TYPE_BOOL},
  {DPID_SWITCH7, DP_TYPE_BOOL},{DPID_SWITCH8, DP_TYPE_BOOL},{DPID_SWITCH9, DP_TYPE_BOOL},{DPID_SWITCH10, DP_TYPE_BOOL},{DPID_SWITCH11, DP_TYPE_BOOL},{DPID_SWITCH12, DP_TYPE_BOOL},
  {DPID_SWITCH13, DP_TYPE_BOOL},{DPID_SWITCH14, DP_TYPE_BOOL},{DPID_SWITCH15, DP_TYPE_BOOL},{DPID_SWITCH16, DP_TYPE_BOOL},
};

unsigned long  last_time = 0;
unsigned long  M433_last_time = 0;
unsigned long  indata_433= 0;
unsigned long  old_indata_433= 0;
unsigned long  key_val_433= 0;
unsigned long  M433_KEY_1= 0;    
unsigned long  M433_KEY_2= 0;    
unsigned long  M433_KEY_3= 0;    
unsigned long  M433_KEY_4= 0;    
unsigned long  M433_KEY_5= 0;    
unsigned long  M433_KEY_6= 0;    
unsigned long  M433_KEY_7= 0;    
unsigned long  M433_KEY_8= 0;    
unsigned long  M433_KEY_9= 0;    
unsigned long  M433_KEY_10= 0;    
unsigned long  M433_KEY_11= 0;    
unsigned long  M433_KEY_12= 0;    
unsigned long  M433_KEY_13= 0;    
unsigned long  M433_KEY_14= 0;    
unsigned long  M433_KEY_15= 0;    
unsigned long  M433_KEY_16= 0;    
int address = 0;

// Set i2c address - output
PCF8574 pcf8574OUT_1(0x21,16,15);
PCF8574 pcf8574OUT_2(0x25,16,15);

// Set i2c address - input
PCF8574 pcf8574IN_1(0x22,16,15);
PCF8574 pcf8574IN_2(0x24,16,15);

//============================================
#define  ADDRESS_M433_KEY_1    0
#define  ADDRESS_M433_KEY_2    10
#define  ADDRESS_M433_KEY_3    20
#define  ADDRESS_M433_KEY_4    30
#define  ADDRESS_M433_KEY_5    40
#define  ADDRESS_M433_KEY_6    50
#define  ADDRESS_M433_KEY_7    60
#define  ADDRESS_M433_KEY_8    70
#define  ADDRESS_M433_KEY_9    80
#define  ADDRESS_M433_KEY_10    90
#define  ADDRESS_M433_KEY_11    100
#define  ADDRESS_M433_KEY_12    110
#define  ADDRESS_M433_KEY_13    120
#define  ADDRESS_M433_KEY_14    130
#define  ADDRESS_M433_KEY_15    140
#define  ADDRESS_M433_KEY_16    150

#define ETH_ADDR        0
#define ETH_POWER_PIN  -1
#define ETH_MDC_PIN    23
#define ETH_MDIO_PIN   18   
#define ETH_TYPE       ETH_PHY_LAN8720
#define ETH_CLK_MODE   ETH_CLOCK_GPIO17_OUT
#define ANALOG_A1   36        // IO36  
#define ANALOG_A2   35        // IO35    
#define ANALOG_A3   34        // IO34   
#define ANALOG_A4   39        // IO39

/********************************************/
const int BEEP_Pin = 2; //蜂鸣器IO2
/*****************************************/
RCSwitch mySwitch = RCSwitch();
/*****************************************/
WiFiUDP Udp;                      
unsigned int localUdpPort = 4196; 
IPAddress local_ip(192, 168, 1, 200); 
IPAddress gateway(192, 168, 1, 1);
IPAddress subnet(255, 255, 255, 0);
IPAddress dns(192, 168, 1, 1);

void setup()
{
  Serial.begin(9600,SERIAL_8N1,14,33);  //tuya模块
  Serial1.begin(115200,SERIAL_8N1,3,1);   //usb下载口

  Serial2.begin(115200,SERIAL_8N1,13,32);  // E16T----485RX  
  
  Serial2.println("KinCony ACBDEFG"); // Enter your print string
  Serial2.println("**************");
  Serial1.println("****aaaaa**********");
  /*******************************************/
  pinMode(ANALOG_A1,INPUT);
  pinMode(ANALOG_A2,INPUT);
  pinMode(ANALOG_A3,INPUT);
  pinMode(ANALOG_A4,INPUT);
  /********************************************/
/******************************************/
  mySwitch.enableReceive(digitalPinToInterrupt(4));  //receive PIN IO4
/***************************************************************************/
  pinMode(BEEP_Pin, OUTPUT);

/**************************************************************************/ 


	// Set pinMode to OUTPUT
	pcf8574OUT_1.pinMode(P0, OUTPUT);
  pcf8574OUT_1.pinMode(P1, OUTPUT);
  pcf8574OUT_1.pinMode(P2, OUTPUT);
  pcf8574OUT_1.pinMode(P3, OUTPUT);
  pcf8574OUT_1.pinMode(P4, OUTPUT);
  pcf8574OUT_1.pinMode(P5, OUTPUT);
  pcf8574OUT_1.pinMode(P6, OUTPUT);
  pcf8574OUT_1.pinMode(P7, OUTPUT);

  pcf8574OUT_2.pinMode(P0, OUTPUT);
  pcf8574OUT_2.pinMode(P1, OUTPUT);
  pcf8574OUT_2.pinMode(P2, OUTPUT);
  pcf8574OUT_2.pinMode(P3, OUTPUT);
  pcf8574OUT_2.pinMode(P4, OUTPUT);
  pcf8574OUT_2.pinMode(P5, OUTPUT);
  pcf8574OUT_2.pinMode(P6, OUTPUT);
  pcf8574OUT_2.pinMode(P7, OUTPUT);

  pcf8574IN_1.pinMode(P0, INPUT);
  pcf8574IN_1.pinMode(P1, INPUT);
  pcf8574IN_1.pinMode(P2, INPUT);
  pcf8574IN_1.pinMode(P3, INPUT);
  pcf8574IN_1.pinMode(P4, INPUT);
  pcf8574IN_1.pinMode(P5, INPUT);
  pcf8574IN_1.pinMode(P6, INPUT);
  pcf8574IN_1.pinMode(P7, INPUT);

  pcf8574IN_2.pinMode(P0, INPUT);
  pcf8574IN_2.pinMode(P1, INPUT);
  pcf8574IN_2.pinMode(P2, INPUT);
  pcf8574IN_2.pinMode(P3, INPUT);
  pcf8574IN_2.pinMode(P4, INPUT);
  pcf8574IN_2.pinMode(P5, INPUT);
  pcf8574IN_2.pinMode(P6, INPUT);
  pcf8574IN_2.pinMode(P7, INPUT);

  pcf8574OUT_1.digitalWrite(P0, HIGH);
  pcf8574OUT_1.digitalWrite(P1, HIGH);
  pcf8574OUT_1.digitalWrite(P2, HIGH);
  pcf8574OUT_1.digitalWrite(P3, HIGH);
  pcf8574OUT_1.digitalWrite(P4, HIGH);
  pcf8574OUT_1.digitalWrite(P5, HIGH);
  pcf8574OUT_1.digitalWrite(P6, HIGH);
  pcf8574OUT_1.digitalWrite(P7, HIGH);

  pcf8574OUT_2.digitalWrite(P0, HIGH);
  pcf8574OUT_2.digitalWrite(P1, HIGH);
  pcf8574OUT_2.digitalWrite(P2, HIGH);
  pcf8574OUT_2.digitalWrite(P3, HIGH);
  pcf8574OUT_2.digitalWrite(P4, HIGH);
  pcf8574OUT_2.digitalWrite(P5, HIGH);
  pcf8574OUT_2.digitalWrite(P6, HIGH);
  pcf8574OUT_2.digitalWrite(P7, HIGH);

	Serial1.print("Init pcf8574OUT_1...");
	if (pcf8574OUT_1.begin()){
		Serial1.println("pcf8574OUT_1_OK");
	}else{
		Serial1.println("pcf8574OUT_1_KO");
	}

  Serial1.print("Init pcf8574OUT_2...");
  if (pcf8574OUT_2.begin()){
    Serial1.println("pcf8574OUT_2_OK");
  }else{
    Serial1.println("pcf8574OUT_2_KO");
  }
//-------------------------------------------
  Serial1.print("Init pcf8574...");
  if (pcf8574IN_1.begin()){
    Serial1.println("pcf8574IN_1_OK");
  }else{
    Serial1.println("pcf8574IN_1_KO");
  }

  Serial1.print("Init pcf8574...");
  if (pcf8574IN_2.begin()){
    Serial1.println("pcf8574IN_2_OK");
  }else{
    Serial1.println("pcf8574IN_2_KO");
  }

Serial1.println("\nTesting EEPROM Library\n");
  if (!EEPROM.begin(1000)) {
    Serial1.println("Failed to initialise EEPROM");
    //Serial1.println("Restarting...");
    delay(1000);
    //ESP.restart();
  }
//-------------------------------------------
      
  
/***********************UDP初始化********************************/ 
   
  ETH.begin(ETH_ADDR, ETH_POWER_PIN, ETH_MDC_PIN, ETH_MDIO_PIN, ETH_TYPE, ETH_CLK_MODE); //start with ETH

  // write confir for static IP, gateway,subnet,dns1,dns2
  if (ETH.config(local_ip, gateway, subnet, dns, dns) == false) {
    Serial2.println("LAN8720 Configuration failed.");
  }else{Serial2.println("LAN8720 Configuration success.");}
  
  Serial2.println("Connected");
  Serial2.print("IP Address:");
  Serial2.println(ETH.localIP());
  Serial2.println("**************");

  Udp.begin(localUdpPort); //begin UDP listener

/************************************************************************************************/    

  address = ADDRESS_M433_KEY_1;
  M433_KEY_1 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_2;
  M433_KEY_2 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_3;
  M433_KEY_3 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_4;
  M433_KEY_4 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_5;
  M433_KEY_5 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_6;
  M433_KEY_6 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_7;
  M433_KEY_7 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_8;
  M433_KEY_8 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_9;
  M433_KEY_9 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_10;
  M433_KEY_10 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_11;
  M433_KEY_11 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_12;
  M433_KEY_12 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_13;
  M433_KEY_13 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_14;
  M433_KEY_14 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_15;
  M433_KEY_15 = EEPROM.readULong(address); 
  address = ADDRESS_M433_KEY_16;
  M433_KEY_16 = EEPROM.readULong(address); 

 // PCF8574::DigitalInput d1_i = pcf8574IN_1.digitalReadAll();
 // PCF8574::DigitalInput d2_i = pcf8574IN_2.digitalReadAll();  
    
//Initialize led port, turn off led.
  pinMode(LED_WiFi, OUTPUT);
  digitalWrite(LED_WiFi, LOW);

  pinMode(key_pin, INPUT);
  //Initialize sel key

    //Enter the PID and MCU software version
  my_device.init(pid, mcu_ver);
  //incoming all DPs and their types array, DP numbers
  my_device.set_dp_cmd_total(dp_array, 1);
  //register DP download processing callback function
  my_device.dp_process_func_register(dp_process);
  //register upload all DP callback function
  my_device.dp_update_all_func_register(dp_update_all);

  last_time = millis();

}

void loop()
{
  /*
	pcf8574OUT_1.digitalWrite(P0, LOW);
  delay(1000);
  pcf8574OUT_1.digitalWrite(P1, LOW);
  delay(1000);
  pcf8574OUT_1.digitalWrite(P2, LOW);
  delay(1000);
  pcf8574OUT_1.digitalWrite(P3, LOW);
  delay(1000);
  pcf8574OUT_1.digitalWrite(P4, LOW);
  delay(1000);
  pcf8574OUT_1.digitalWrite(P5, LOW);
  delay(1000);
  pcf8574OUT_1.digitalWrite(P6, LOW);
  delay(1000);
  pcf8574OUT_1.digitalWrite(P7, LOW);
  delay(1000);

  pcf8574OUT_2.digitalWrite(P0, LOW);
  delay(1000);
  pcf8574OUT_2.digitalWrite(P1, LOW);
  delay(1000);
  pcf8574OUT_2.digitalWrite(P2, LOW);
  delay(1000);
  pcf8574OUT_2.digitalWrite(P3, LOW);
  delay(1000);
  pcf8574OUT_2.digitalWrite(P4, LOW);
  delay(1000);
  pcf8574OUT_2.digitalWrite(P5, LOW);
  delay(1000);
  pcf8574OUT_2.digitalWrite(P6, LOW);
  delay(1000);
  pcf8574OUT_2.digitalWrite(P7, LOW);
  delay(1000);*/

//-----------------------------------


   if(digitalRead(0)==LOW)
  {
    delay(20);
     if(digitalRead(0)==LOW)
  {
    Serial2.println("Download key ok");
    digitalWrite(BEEP_Pin, HIGH);
    delay(500);
    digitalWrite(BEEP_Pin, LOW);
  }
  }
  
  while(Serial2.available()>0)
   {
    Serial2.print((char)Serial2.read());//print    rs485 receive
    
   }
  //delay(200);
 
/************************************************/
  if(analogRead(ANALOG_A1)!=0)
    {  Serial2.printf("Current Reading A1 on Pin(%d)=%d\n",ANALOG_A1,analogRead(ANALOG_A1));}
  if(analogRead(ANALOG_A2)!=0)
    {  Serial2.printf("Current Reading A2 on Pin(%d)=%d\n",ANALOG_A2,analogRead(ANALOG_A2));}
  if(analogRead(ANALOG_A3)!=0)
    {  Serial2.printf("Current Reading A3 on Pin(%d)=%d\n",ANALOG_A3,analogRead(ANALOG_A3));}
  if(analogRead(ANALOG_A4)!=0)
    {  Serial2.printf("Current Reading A4 on Pin(%d)=%d\n",ANALOG_A4,analogRead(ANALOG_A4));}  
//-----------------------------------------------------------------------------------

  int packetSize = Udp.parsePacket(); //get package size
  if (packetSize)                     //if have received data
  {
    char buf[packetSize];
    Udp.read(buf, packetSize); //read current data

    Serial2.println();
    Serial2.print("Received: ");
    Serial2.println(buf);
    Serial2.print("From IP: ");
    Serial2.println(Udp.remoteIP());
    Serial2.print("From Port: ");
    Serial2.println(Udp.remotePort());

    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort()); //ready to send data
    Udp.print("Received: ");    
    Udp.write((const uint8_t*)buf, packetSize); //copy data to sender buffer
    Udp.endPacket();            //send data
  }



//----------------------------------------------------------------------------------------------
     my_device.uart_service();

  //Enter the connection network mode when Pin27 is pressed.
  if (digitalRead(key_pin) == LOW) {
    delay(20);
    if (digitalRead(key_pin) == LOW) {
      Serial1.println("begin smart config");
      my_device.mcu_set_wifi_mode(SMART_CONFIG);
      
    }
  }
  /* LED blinks when network is being connected */
  if ((my_device.mcu_get_wifi_work_state() != WIFI_LOW_POWER) && (my_device.mcu_get_wifi_work_state() != WIFI_CONN_CLOUD) && (my_device.mcu_get_wifi_work_state() != WIFI_SATE_UNKNOW)) {
    if (millis()- last_time >= 500) {
      last_time = millis();

      if (led_state == LOW) {
        led_state = HIGH;
      } else {
        led_state = LOW;
      }
      digitalWrite(LED_WiFi, led_state);
    }
  }
 Scan433();
 ScanKey();
}


/**
 * @description: DP download callback function.
 * @param {unsigned char} dpid
 * @param {const unsigned char} value
 * @param {unsigned short} length
 * @return {unsigned char}
 */
unsigned char dp_process(unsigned char dpid,const unsigned char value[], unsigned short length)
{
  switch(dpid) {
    case DPID_SWITCH_1:
      switch_1_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      Serial1.println(switch_1_state);
      if (switch_1_state) {
        //Turn on
       pcf8574OUT_1.digitalWrite(P0, LOW);
      } else {
        //Turn off
       pcf8574OUT_1.digitalWrite(P0, HIGH);
      }
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_2:
      switch_2_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_2_state) {
        //Turn on
       pcf8574OUT_1.digitalWrite(P1, LOW);
      } else {
        //Turn off
       pcf8574OUT_1.digitalWrite(P1, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_3:
      switch_3_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_3_state) {
        //Turn on
       pcf8574OUT_1.digitalWrite(P2, LOW);
      } else {
        //Turn off
       pcf8574OUT_1.digitalWrite(P2, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_4:
      switch_4_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_4_state) {
        //Turn on
       pcf8574OUT_1.digitalWrite(P3, LOW);
      } else {
        //Turn off
       pcf8574OUT_1.digitalWrite(P3, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_5:
      switch_5_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_5_state) {
        //Turn on
       pcf8574OUT_1.digitalWrite(P4, LOW);
      } else {
        //Turn off
       pcf8574OUT_1.digitalWrite(P4, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_6:
      switch_6_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_6_state) {
        //Turn on
       pcf8574OUT_1.digitalWrite(P5, LOW);
      } else {
        //Turn off
       pcf8574OUT_1.digitalWrite(P5, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH7:
      switch_7_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_7_state) {
        //Turn on
       pcf8574OUT_1.digitalWrite(P6, LOW);
      } else {
        //Turn off
       pcf8574OUT_1.digitalWrite(P6, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH8:
      switch_8_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_8_state) {
        //Turn on
       pcf8574OUT_1.digitalWrite(P7, LOW);
      } else {
        //Turn off
       pcf8574OUT_1.digitalWrite(P7, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH9:
      switch_9_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_9_state) {
        //Turn on
       pcf8574OUT_2.digitalWrite(P0, LOW);
      } else {
        //Turn off
       pcf8574OUT_2.digitalWrite(P0, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH10:
      switch_10_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_10_state) {
        //Turn on
       pcf8574OUT_2.digitalWrite(P1, LOW);
      } else {
        //Turn off
       pcf8574OUT_2.digitalWrite(P1, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH11:
      switch_11_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_11_state) {
        //Turn on
       pcf8574OUT_2.digitalWrite(P2, LOW);
      } else {
        //Turn off
       pcf8574OUT_2.digitalWrite(P2, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH12:
      switch_12_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_12_state) {
        //Turn on
       pcf8574OUT_2.digitalWrite(P3, LOW);
      } else {
        //Turn off
       pcf8574OUT_2.digitalWrite(P3, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length); 
    break;

    case DPID_SWITCH13:
      switch_13_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_13_state) {
        //Turn on
       pcf8574OUT_2.digitalWrite(P4, LOW);
      } else {
        //Turn off
       pcf8574OUT_2.digitalWrite(P4, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH14:
      switch_14_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_14_state) {
        //Turn on
       pcf8574OUT_2.digitalWrite(P5, LOW);
      } else {
        //Turn off
       pcf8574OUT_2.digitalWrite(P5, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH15:
      switch_15_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_15_state) {
        //Turn on
       pcf8574OUT_2.digitalWrite(P6, LOW);
      } else {
        //Turn off
       pcf8574OUT_2.digitalWrite(P6, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH16:
      switch_16_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_16_state) {
        //Turn on
       pcf8574OUT_2.digitalWrite(P7, LOW);
      } else {
        //Turn off
       pcf8574OUT_2.digitalWrite(P7, HIGH);
      }
      //Status changes should be reported.
      my_device.mcu_dp_update(dpid, value, length);
    break;


    default:break;
  }


  //===============================================================================


  
  return TY_SUCCESS;
}

/**
 * @description: Upload all DP status of the current device.
 * @param {*}
 * @return {*}
 */
void dp_update_all(void)
{
  my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);

  my_device.mcu_dp_update(DPID_SWITCH7, switch_7_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH8, switch_8_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH9, switch_9_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH10, switch_10_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH11, switch_11_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH12, switch_12_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH13, switch_13_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH14, switch_14_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH15, switch_15_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH16, switch_16_state, 1);
}


void Scan433()            
{
if (mySwitch.available()) {
    Serial2.print("Received ");
    //Serial1.print("Received ");
    indata_433 = mySwitch.getReceivedValue() ;
    Serial2.println( indata_433 );
    //Serial1.println( indata_433 );
    key_val_433 = indata_433 ;

  if((indata_433!=old_indata_433)||((indata_433==old_indata_433)&&((millis()-M433_last_time)>800)))
  {
    
         if(key_val_433==M433_KEY_1)   
      {
      Serial2.println("key1 is pressed");
      pcf8574OUT_1.digitalWrite(P0,!pcf8574OUT_1.digitalRead(P0));    // toggle relay1 state     
      //while(pcf8574IN_1.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P0) == LOW) my_device.mcu_dp_update(DPID_SWITCH_1, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_1, 0, 1);
      }      

         if(key_val_433==M433_KEY_2)   
      {
      Serial2.println("key2 is pressed");
      pcf8574OUT_1.digitalWrite(P1,!pcf8574OUT_1.digitalRead(P1));    // toggle relay2 state     
      //while(pcf8574IN_1.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P1) == LOW) my_device.mcu_dp_update(DPID_SWITCH_2, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_2, 0, 1);
      }      

         if(key_val_433==M433_KEY_3)   
      {
      Serial2.println("key3 is pressed");
      pcf8574OUT_1.digitalWrite(P2,!pcf8574OUT_1.digitalRead(P2));    // toggle relay3 state     
      //while(pcf8574IN_1.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P2) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_3, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_3, 0, 1);
      }      
                  
         if(key_val_433==M433_KEY_4)   
      {
      Serial2.println("key4 is pressed");
      pcf8574OUT_1.digitalWrite(P3,!pcf8574OUT_1.digitalRead(P3));    // toggle relay4 state     
      //while(pcf8574IN_1.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P3) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_4, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_4, 0, 1);
      }      

         if(key_val_433==M433_KEY_5)   
      {
      Serial2.println("key5 is pressed");
      pcf8574OUT_1.digitalWrite(P4,!pcf8574OUT_1.digitalRead(P4));    // toggle relay5 state     
      //while(pcf8574IN_1.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P4) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_5, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_5, 0, 1);
      }      

         if(key_val_433==M433_KEY_6)   
      {
      Serial2.println("key6 is pressed");
      pcf8574OUT_1.digitalWrite(P5,!pcf8574OUT_1.digitalRead(P5));    // toggle relay6 state     
      //while(pcf8574IN_1.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P5) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_6, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_6, 0, 1);
      }      

         if(key_val_433==M433_KEY_7)   
      {
      Serial2.println("key7 is pressed");
      pcf8574OUT_1.digitalWrite(P6,!pcf8574OUT_1.digitalRead(P6));    // toggle relay7 state     
      //while(pcf8574IN_1.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P6) == LOW)  my_device.mcu_dp_update(DPID_SWITCH7, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH7, 0, 1);
      }      

         if(key_val_433==M433_KEY_8)   
      {
      Serial2.println("key8 is pressed");
      pcf8574OUT_1.digitalWrite(P7,!pcf8574OUT_1.digitalRead(P7));    // toggle relay8 state     
      //while(pcf8574IN_1.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P7) == LOW)  my_device.mcu_dp_update(DPID_SWITCH8, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH8, 0, 1);
      }      

         if(key_val_433==M433_KEY_9)   
      {
      Serial2.println("key9 is pressed");
      pcf8574OUT_2.digitalWrite(P0,!pcf8574OUT_2.digitalRead(P0));    // toggle relay9 state     
      //while(pcf8574IN_2.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P0) == LOW)  my_device.mcu_dp_update(DPID_SWITCH9, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH9, 0, 1);
      }      

         if(key_val_433==M433_KEY_10)   
      {
      Serial2.println("key10 is pressed");
      pcf8574OUT_2.digitalWrite(P1,!pcf8574OUT_2.digitalRead(P1));    // toggle relay10 state     
      //while(pcf8574IN_2.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P1) == LOW)  my_device.mcu_dp_update(DPID_SWITCH10, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH10, 0, 1);
      }      

         if(key_val_433==M433_KEY_11)   
      {
      Serial2.println("key11 is pressed");
      pcf8574OUT_2.digitalWrite(P2,!pcf8574OUT_2.digitalRead(P2));    // toggle relay11 state     
      //while(pcf8574IN_2.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P2) == LOW)  my_device.mcu_dp_update(DPID_SWITCH11, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH11, 0, 1);
      }      
 
         if(key_val_433==M433_KEY_12)   
      {
      Serial2.println("key12 is pressed");
      pcf8574OUT_2.digitalWrite(P3,!pcf8574OUT_2.digitalRead(P3));    // toggle relay12 state     
      //while(pcf8574IN_2.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P3) == LOW)  my_device.mcu_dp_update(DPID_SWITCH12, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH12, 0, 1);
      }      

         if(key_val_433==M433_KEY_13)   
      {
      Serial2.println("key13 is pressed");
      pcf8574OUT_2.digitalWrite(P4,!pcf8574OUT_2.digitalRead(P4));    // toggle relay13 state     
      //while(pcf8574IN_2.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P4) == LOW)  my_device.mcu_dp_update(DPID_SWITCH13, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH13, 0, 1);
      }      

         if(key_val_433==M433_KEY_14)   
      {
      Serial2.println("key14 is pressed");
      pcf8574OUT_2.digitalWrite(P5,!pcf8574OUT_2.digitalRead(P5));    // toggle relay14 state     
      //while(pcf8574IN_2.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P5) == LOW)  my_device.mcu_dp_update(DPID_SWITCH14, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH14, 0, 1);
      }      

         if(key_val_433==M433_KEY_15)   
      {
      Serial2.println("key15 is pressed");
      pcf8574OUT_2.digitalWrite(P6,!pcf8574OUT_2.digitalRead(P6));    // toggle relay15 state     
      //while(pcf8574IN_2.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P6) == LOW)  my_device.mcu_dp_update(DPID_SWITCH15, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH15, 0, 1);
      }      

         if(key_val_433==M433_KEY_16)   
      {
      Serial2.println("key16 is pressed");
      pcf8574OUT_2.digitalWrite(P7,!pcf8574OUT_2.digitalRead(P7));    // toggle relay16 state     
      //while(pcf8574IN_2.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P7) == LOW)  my_device.mcu_dp_update(DPID_SWITCH16, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH16, 0, 1);
      }      

   }
   
     old_indata_433=indata_433; 
     indata_433=0;
     key_val_433 = 0; 
     M433_last_time = millis();

    mySwitch.resetAvailable();      
  }

}

void ScanKey()            
{
  PCF8574::DigitalInput d1_i = pcf8574IN_1.digitalReadAll();
  PCF8574::DigitalInput d2_i = pcf8574IN_2.digitalReadAll();  

  if(!((d1_i.p0)&&(d1_i.p1)&&(d1_i.p2)&&(d1_i.p3)&&(d1_i.p4)&&(d1_i.p5)&&(d1_i.p6)&&(d1_i.p7)&&(d2_i.p0)&&(d2_i.p1)&&(d2_i.p2)&&(d2_i.p3)&&(d2_i.p4)&&(d2_i.p5)&&(d2_i.p6)&&(d2_i.p7)))
  {
    
         if(d1_i.p0==0)   
      {
      Serial2.println("key1 is pressed");
      Serial1.println("key1 is pressed");
      pcf8574OUT_1.digitalWrite(P0,!pcf8574OUT_1.digitalRead(P0));    // toggle relay1 state     
      //while(pcf8574IN_1.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P0) == LOW) my_device.mcu_dp_update(DPID_SWITCH_1, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_1, 0, 1);
      }      

         if(d1_i.p1==0)   
      {
      Serial2.println("key2 is pressed");
      Serial1.println("key2 is pressed");
      pcf8574OUT_1.digitalWrite(P1,!pcf8574OUT_1.digitalRead(P1));    // toggle relay2 state     
      //while(pcf8574IN_1.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P1) == LOW) my_device.mcu_dp_update(DPID_SWITCH_2, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_2, 0, 1);
      }      

         if(d1_i.p2==0)   
      {
      Serial2.println("key3 is pressed");
      Serial1.println("key3 is pressed");
      pcf8574OUT_1.digitalWrite(P2,!pcf8574OUT_1.digitalRead(P2));    // toggle relay3 state     
      //while(pcf8574IN_1.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P2) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_3, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_3, 0, 1);
      }      
                  
         if(d1_i.p3==0)   
      {
      Serial2.println("key4 is pressed");
      pcf8574OUT_1.digitalWrite(P3,!pcf8574OUT_1.digitalRead(P3));    // toggle relay4 state     
      //while(pcf8574IN_1.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P3) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_4, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_4, 0, 1);
      }      

         if(d1_i.p4==0)   
      {
      Serial2.println("key5 is pressed");
      pcf8574OUT_1.digitalWrite(P4,!pcf8574OUT_1.digitalRead(P4));    // toggle relay5 state     
      //while(pcf8574IN_1.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P4) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_5, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_5, 0, 1);
      }      

         if(d1_i.p5==0)   
      {
      Serial2.println("key6 is pressed");
      pcf8574OUT_1.digitalWrite(P5,!pcf8574OUT_1.digitalRead(P5));    // toggle relay6 state     
      //while(pcf8574IN_1.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P5) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_6, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_6, 0, 1);
      }      

         if(d1_i.p6==0)   
      {
      Serial2.println("key7 is pressed");
      pcf8574OUT_1.digitalWrite(P6,!pcf8574OUT_1.digitalRead(P6));    // toggle relay7 state     
      //while(pcf8574IN_1.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P6) == LOW)  my_device.mcu_dp_update(DPID_SWITCH7, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH7, 0, 1);
      }      

         if(d1_i.p7==0)   
      {
      Serial2.println("key8 is pressed");
      pcf8574OUT_1.digitalWrite(P7,!pcf8574OUT_1.digitalRead(P7));    // toggle relay8 state     
      //while(pcf8574IN_1.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P7) == LOW)  my_device.mcu_dp_update(DPID_SWITCH8, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH8, 0, 1);
      }      

         if(d2_i.p0==0)   
      {
      Serial2.println("key9 is pressed");
      pcf8574OUT_2.digitalWrite(P0,!pcf8574OUT_2.digitalRead(P0));    // toggle relay9 state     
      //while(pcf8574IN_2.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P0) == LOW)  my_device.mcu_dp_update(DPID_SWITCH9, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH9, 0, 1);
      }      

         if(d2_i.p1==0)   
      {
      Serial2.println("key10 is pressed");
      pcf8574OUT_2.digitalWrite(P1,!pcf8574OUT_2.digitalRead(P1));    // toggle relay10 state     
      //while(pcf8574IN_2.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P1) == LOW)  my_device.mcu_dp_update(DPID_SWITCH10, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH10, 0, 1);
      }      

         if(d2_i.p2==0)   
      {
      Serial2.println("key11 is pressed");
      pcf8574OUT_2.digitalWrite(P2,!pcf8574OUT_2.digitalRead(P2));    // toggle relay11 state     
      //while(pcf8574IN_2.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P2) == LOW)  my_device.mcu_dp_update(DPID_SWITCH11, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH11, 0, 1);
      }      
 
         if(d2_i.p3==0)   
      {
      Serial2.println("key12 is pressed");
      pcf8574OUT_2.digitalWrite(P3,!pcf8574OUT_2.digitalRead(P3));    // toggle relay12 state     
      //while(pcf8574IN_2.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P3) == LOW)  my_device.mcu_dp_update(DPID_SWITCH12, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH12, 0, 1);
      }      

         if(d2_i.p4==0)   
      {
      Serial2.println("key13 is pressed");
      pcf8574OUT_2.digitalWrite(P4,!pcf8574OUT_2.digitalRead(P4));    // toggle relay13 state     
      //while(pcf8574IN_2.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P4) == LOW)  my_device.mcu_dp_update(DPID_SWITCH13, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH13, 0, 1);
      }      

         if(d2_i.p5==0)   
      {
      Serial2.println("key14 is pressed");
      pcf8574OUT_2.digitalWrite(P5,!pcf8574OUT_2.digitalRead(P5));    // toggle relay14 state     
      //while(pcf8574IN_2.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P5) == LOW)  my_device.mcu_dp_update(DPID_SWITCH14, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH14, 0, 1);
      }      

         if(d2_i.p6==0)   
      {
      Serial2.println("key15 is pressed");
      pcf8574OUT_2.digitalWrite(P6,!pcf8574OUT_2.digitalRead(P6));    // toggle relay15 state     
      //while(pcf8574IN_2.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P6) == LOW)  my_device.mcu_dp_update(DPID_SWITCH15, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH15, 0, 1);
      }      

         if(d2_i.p7==0)   
      {
      Serial2.println("key16 is pressed");
      pcf8574OUT_2.digitalWrite(P7,!pcf8574OUT_2.digitalRead(P7));    // toggle relay16 state     
      //while(pcf8574IN_2.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P7) == LOW)  my_device.mcu_dp_update(DPID_SWITCH16, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH16, 0, 1);
      }      
  WaitKey();
  }
  
}

void WaitKey()            
{
  PCF8574::DigitalInput d1_i = pcf8574IN_1.digitalReadAll();
  PCF8574::DigitalInput d2_i = pcf8574IN_2.digitalReadAll();  

  while(!((d1_i.p0)&&(d1_i.p1)&&(d1_i.p2)&&(d1_i.p3)&&(d1_i.p4)&&(d1_i.p5)&&(d1_i.p6)&&(d1_i.p7)&&(d2_i.p0)&&(d2_i.p1)&&(d2_i.p2)&&(d2_i.p3)&&(d2_i.p4)&&(d2_i.p5)&&(d2_i.p6)&&(d2_i.p7)))
  {
     d1_i = pcf8574IN_1.digitalReadAll();
     d2_i = pcf8574IN_2.digitalReadAll();  


   if (mySwitch.available()) {
    Serial2.print("Received ");
    Serial1.print("Received ");
    indata_433 = mySwitch.getReceivedValue() ;
    Serial2.println( indata_433 );
    Serial1.println( indata_433 );
    key_val_433 = indata_433 ;

  if((indata_433!=old_indata_433)||((indata_433==old_indata_433)&&((millis()-M433_last_time)>1000)))
     {
         if(d1_i.p0==0)   
      {

     address = ADDRESS_M433_KEY_1;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_1 = key_val_433; 

      Serial2.println("key1 is pressed");
      pcf8574OUT_1.digitalWrite(P0,!pcf8574OUT_1.digitalRead(P0));    // toggle relay1 state     
      //while(pcf8574IN_1.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P0) == LOW) my_device.mcu_dp_update(DPID_SWITCH_1, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_1, 0, 1);
      }      

         if(d1_i.p1==0)   
      {

     address = ADDRESS_M433_KEY_2;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_2 = key_val_433; 
     
      Serial2.println("key2 is pressed");
      pcf8574OUT_1.digitalWrite(P1,!pcf8574OUT_1.digitalRead(P1));    // toggle relay2 state     
      //while(pcf8574IN_1.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P1) == LOW) my_device.mcu_dp_update(DPID_SWITCH_2, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_2, 0, 1);
      }      

         if(d1_i.p2==0)   
      {

     address = ADDRESS_M433_KEY_3;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_3 = key_val_433; 

      Serial2.println("key3 is pressed");
      pcf8574OUT_1.digitalWrite(P2,!pcf8574OUT_1.digitalRead(P2));    // toggle relay3 state     
      //while(pcf8574IN_1.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P2) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_3, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_3, 0, 1);
      }      
                  
         if(d1_i.p3==0)   
      {

     address = ADDRESS_M433_KEY_4;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_4 = key_val_433; 
        
      Serial2.println("key4 is pressed");
      pcf8574OUT_1.digitalWrite(P3,!pcf8574OUT_1.digitalRead(P3));    // toggle relay4 state     
      //while(pcf8574IN_1.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P3) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_4, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_4, 0, 1);
      }      

         if(d1_i.p4==0)   
      {

     address = ADDRESS_M433_KEY_5;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_5 = key_val_433; 
        
      Serial2.println("key5 is pressed");
      pcf8574OUT_1.digitalWrite(P4,!pcf8574OUT_1.digitalRead(P4));    // toggle relay5 state     
      //while(pcf8574IN_1.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P4) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_5, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_5, 0, 1);
      }      

         if(d1_i.p5==0)   
      {

     address = ADDRESS_M433_KEY_6;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_6 = key_val_433; 
        
      Serial2.println("key6 is pressed");
      pcf8574OUT_1.digitalWrite(P5,!pcf8574OUT_1.digitalRead(P5));    // toggle relay6 state     
      //while(pcf8574IN_1.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P5) == LOW)  my_device.mcu_dp_update(DPID_SWITCH_6, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH_6, 0, 1);
      }      

         if(d1_i.p6==0)   
      {

     address = ADDRESS_M433_KEY_7;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_7 = key_val_433; 
        
      Serial2.println("key7 is pressed");
      pcf8574OUT_1.digitalWrite(P6,!pcf8574OUT_1.digitalRead(P6));    // toggle relay7 state     
      //while(pcf8574IN_1.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P6) == LOW)  my_device.mcu_dp_update(DPID_SWITCH7, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH7, 0, 1);
      }      

         if(d1_i.p7==0)   
      {

     address = ADDRESS_M433_KEY_8;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_8 = key_val_433; 
        
      Serial2.println("key8 is pressed");
      pcf8574OUT_1.digitalWrite(P7,!pcf8574OUT_1.digitalRead(P7));    // toggle relay8 state     
      //while(pcf8574IN_1.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574OUT_1.digitalRead(P7) == LOW)  my_device.mcu_dp_update(DPID_SWITCH8, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH8, 0, 1);
      }      

         if(d2_i.p0==0)   
      {

     address = ADDRESS_M433_KEY_9;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_9 = key_val_433; 
        
      Serial2.println("key9 is pressed");
      pcf8574OUT_2.digitalWrite(P0,!pcf8574OUT_2.digitalRead(P0));    // toggle relay9 state     
      //while(pcf8574IN_2.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P0) == LOW)  my_device.mcu_dp_update(DPID_SWITCH9, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH9, 0, 1);
      }      

         if(d2_i.p1==0)   
      {

     address = ADDRESS_M433_KEY_10;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_10 = key_val_433; 
        
      Serial2.println("key10 is pressed");
      pcf8574OUT_2.digitalWrite(P1,!pcf8574OUT_2.digitalRead(P1));    // toggle relay10 state     
      //while(pcf8574IN_2.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P1) == LOW)  my_device.mcu_dp_update(DPID_SWITCH10, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH10, 0, 1);
      }      

         if(d2_i.p2==0)   
      {

     address = ADDRESS_M433_KEY_11;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_11 = key_val_433; 
        
      Serial2.println("key11 is pressed");
      pcf8574OUT_2.digitalWrite(P2,!pcf8574OUT_2.digitalRead(P2));    // toggle relay11 state     
      //while(pcf8574IN_2.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P2) == LOW)  my_device.mcu_dp_update(DPID_SWITCH11, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH11, 0, 1);
      }      
 
         if(d2_i.p3==0)   
      {

     address = ADDRESS_M433_KEY_12;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_12 = key_val_433; 
        
      Serial2.println("key12 is pressed");
      pcf8574OUT_2.digitalWrite(P3,!pcf8574OUT_2.digitalRead(P3));    // toggle relay12 state     
      //while(pcf8574IN_2.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P3) == LOW)  my_device.mcu_dp_update(DPID_SWITCH12, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH12, 0, 1);
      }      

         if(d2_i.p4==0)   
      {

     address = ADDRESS_M433_KEY_13;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_13 = key_val_433; 
        
      Serial2.println("key13 is pressed");
      pcf8574OUT_2.digitalWrite(P4,!pcf8574OUT_2.digitalRead(P4));    // toggle relay13 state     
      //while(pcf8574IN_2.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P4) == LOW)  my_device.mcu_dp_update(DPID_SWITCH13, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH13, 0, 1);
      }      

         if(d2_i.p5==0)   
      {

     address = ADDRESS_M433_KEY_14;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_14 = key_val_433; 
        
      Serial2.println("key14 is pressed");
      pcf8574OUT_2.digitalWrite(P5,!pcf8574OUT_2.digitalRead(P5));    // toggle relay14 state     
      //while(pcf8574IN_2.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P5) == LOW)  my_device.mcu_dp_update(DPID_SWITCH14, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH14, 0, 1);
      }      

         if(d2_i.p6==0)   
      {

     address = ADDRESS_M433_KEY_15;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_15 = key_val_433; 
        
      Serial2.println("key15 is pressed");
      pcf8574OUT_2.digitalWrite(P6,!pcf8574OUT_2.digitalRead(P6));    // toggle relay15 state     
      //while(pcf8574IN_2.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P6) == LOW)  my_device.mcu_dp_update(DPID_SWITCH15, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH15, 0, 1);
      }      

         if(d2_i.p7==0)   
      {

     address = ADDRESS_M433_KEY_16;   
     EEPROM.writeULong(address, key_val_433);
     EEPROM.commit();
     M433_KEY_16 = key_val_433; 
        
      Serial2.println("key16 is pressed");
      pcf8574OUT_2.digitalWrite(P7,!pcf8574OUT_2.digitalRead(P7));    // toggle relay16 state     
      //while(pcf8574IN_2.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574OUT_2.digitalRead(P7) == LOW)  my_device.mcu_dp_update(DPID_SWITCH16, 1, 1); else my_device.mcu_dp_update(DPID_SWITCH16, 0, 1);
      }      

   }
     old_indata_433=indata_433; 
     indata_433=0; 
     M433_last_time = millis();

    mySwitch.resetAvailable();      
  }

  }
  
}
