#include <EEPROM.h>
#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <ESP8266WiFiMulti.h>
#include <WebSocketsClient.h> 
#include <ArduinoJson.h>
#include <StreamString.h>

#define MAX_LEN         2048  // 存储器最大空间   
#define ARRAY_NUM       38    //  数组第第一维总共有38个
#define ARRAY_DAT_NUM   50    //  每个数组最多可存放50个char数据
#define MAX_REC_LEN     (ARRAY_NUM)*(ARRAY_DAT_NUM)
#define SERIAL_RATES    115200  //  设置波特率
#define ERROR           -1    //  操作失败
#define DELIM           ','   //
#define FIRST_DELIM_POS   2   // A/B 0/1 , 0-9 0-9 0-9 0-9 ,,,,,, 
#define SECOND_DELIM_POS  7   //
#define REC_DATA_LEN_POS  3   //接收数据长度所在位置
#define GET_SAVE_POS      0   //读取保存数据的位置
#define GET_REC_LEN       8   //
#define MEM_SAVE_START_POS 9  //
#define ID_EQUAL       0   //判断两个字符串是否相等
char rec_cmd[MAX_REC_LEN]={0};    // 接收缓冲区
char tmp_data[ARRAY_NUM][ARRAY_DAT_NUM];// 保存数据

int  rec_cnt = 0;                 //保存接收个数
static int g_rec_dat_len = 0;     //保存串口接收长度  

ESP8266WiFiMulti WiFiMulti;
WebSocketsClient webSocket;
WiFiClient client;
#if 0
//-----------------------Following changed by yourself accoring to your Router and device information-------------------------------------------
#define MyApiKey "1330c3cc-2e31-49ab-91cb-0b2b2cc91659" // TODO: Change to your sinric API Key. Your API Key is displayed on sinric.com dashboard
#define MySSID "cmcct" // TODO: Change to your Wifi network SSID
#define MyWifiPassword "wifi2018" // TODO: Change to your Wifi network password
#endif
#define SSID_POS      0
#define PASSWORD_POS    1
#define APIKEY_POS      2
#define RELAY_POS     3
#define DELAY_FLG_POS   4
#define NEED_CLEAR_MEM 0//实际测试时候，置零，不需要清空EEPROM
#define Relay1 "5cbd7f7d6bd4b204f33b74b2" // Device ID of Relay1 , which is displayed on sinric.com dashboard
#define Relay2 "5cbd5e976bd4b204f33b6d30" // Device ID of Relay2 , which is displayed on sinric.com dashboard
#define Relay3 "5cbd81826bd4b204f33b751f" // Device ID of Relay3 , which is displayed on sinric.com dashboard
#define Relay4 "5cbd818a6bd4b204f33b7521" // Device ID of Relay4 , which is displayed on sinric.com dashboard
#define Relay5 "5cbd81906bd4b204f33b7526" // Device ID of Relay5 , which is displayed on sinric.com dashboard
#define Relay6 "5cbd81986bd4b204f33b7528" // Device ID of Relay6 , which is displayed on sinric.com dashboard
#define Relay7 "5cbd819e6bd4b204f33b752d" // Device ID of Relay7 , which is displayed on sinric.com dashboard
#define Relay8 "5cbd81a56bd4b204f33b752f" // Device ID of Relay8 , which is displayed on sinric.com dashboard
#define Relay9 "5cbe7915d9de190de153a056" // Device ID of Relay9 , which is displayed on sinric.com dashboard
#define Relay10 "5cbe7923d9de190de153a05c" // Device ID of Relay10 , which is displayed on sinric.com dashboard
#define Relay11 "5cbe792bd9de190de153a062" // Device ID of Relay11 , which is displayed on sinric.com dashboard
#define Relay12 "5cbe7933d9de190de153a068" // Device ID of Relay12 , which is displayed on sinric.com dashboard
#define Relay13 "5cbe793ad9de190de153a06a" // Device ID of Relay13 , which is displayed on sinric.com dashboard
#define Relay14 "5cbe7940d9de190de153a070" // Device ID of Relay14 , which is displayed on sinric.com dashboard
#define Relay15 "5cbe7946d9de190de153a076" // Device ID of Relay15 , which is displayed on sinric.com dashboard
#define Relay16 "5cbe794dd9de190de153a078" // Device ID of Relay16 , which is displayed on sinric.com dashboard
#define Relay17 "5cbe7953d9de190de153a07e" // Device ID of Relay17 , which is displayed on sinric.com dashboard
#define Relay18 "5cbe795ad9de190de153a080" // Device ID of Relay18 , which is displayed on sinric.com dashboard
#define Relay19 "5cbe7960d9de190de153a086" // Device ID of Relay19 , which is displayed on sinric.com dashboard
#define Relay20 "5cbe7968d9de190de153a08c" // Device ID of Relay20 , which is displayed on sinric.com dashboard
#define Relay21 "5cbe796ed9de190de153a08e" // Device ID of Relay21 , which is displayed on sinric.com dashboard
#define Relay22 "5cbe7973d9de190de153a094" // Device ID of Relay22 , which is displayed on sinric.com dashboard
#define Relay23 "5cbe7979d9de190de153a096" // Device ID of Relay23 , which is displayed on sinric.com dashboard
#define Relay24 "5cbe7980d9de190de153a09c" // Device ID of Relay24 , which is displayed on sinric.com dashboard
#define Relay25 "5cbe7986d9de190de153a0a2" // Device ID of Relay25 , which is displayed on sinric.com dashboard
#define Relay26 "5cbe798cd9de190de153a0a4" // Device ID of Relay26 , which is displayed on sinric.com dashboard
#define Relay27 "5cbe7992d9de190de153a0aa" // Device ID of Relay27 , which is displayed on sinric.com dashboard
#define Relay28 "5cbe7998d9de190de153a0ac" // Device ID of Relay28 , which is displayed on sinric.com dashboard
#define Relay29 "5cbe799ed9de190de153a0b2" // Device ID of Relay29 , which is displayed on sinric.com dashboard
#define Relay30 "5cbe79a7d9de190de153a0b8" // Device ID of Relay30 , which is displayed on sinric.com dashboard
#define Relay31 "5cbe79acd9de190de153a0ba" // Device ID of Relay31 , which is displayed on sinric.com dashboard
#define Relay32 "5cbe79b1d9de190de153a0c0" // Device ID of Relay32 , which is displayed on sinric.com dashboard
//---------------------------------------------------------------------------------------------------------------------------------------------
#define HEARTBEAT_INTERVAL 300000 // 5 Minutes 
uint64_t heartbeatTimestamp = 0;
bool isConnected = false;
int32_t g_init_status_flg = 0;
int8_t  g_start_dat[MEM_SAVE_START_POS] = {0};
void setPowerStateOnServer(String deviceId, String value);
void setTargetTemperatureOnServer(String deviceId, String value, String scale);
void webSocketEvent(WStype_t type, uint8_t * payload, size_t length);
// deviceId is the ID assgined to your smart-home-device in sinric.com dashboard. Copy it from dashboard and paste it here
/*
*@brief 清空存储空间，测试使用
*param
*param
*/
void clear_memory()
{
    int i = 0;
    for(i = 0; i< MAX_LEN; i++)
    {
        EEPROM.write(i, 0x00);
    }
    EEPROM.end();
}
/*
*@brief 得到保存数据的长度，保存在EEPROM里面的数据格式是自定义的，外部关心的只是串口的协议。
        保存在EEPROM里面的数据开头9个字节分别是
    0X5a 0x4a 0x48 0x7a 保存数据的长度（4字节）
    说明： 0X5a 0x4a 0x48 0x7a保存这个开头是为了判断这段EEPROM有没有保存过，如果没有的话，我们需要初始化一次。
           保存数据长度： 现在只是用该长度判断数据有没有越界，如果越界，长度会重写置零
*param
*/
int16_t getSaveDatLen(void)
{
  int16_t len = 0;
  int8_t i = 0;
  for(i = 0; i< sizeof(g_start_dat); i++)
  {
      g_start_dat[i] = EEPROM.read(i);
  }
  len = ((g_start_dat[MEM_SAVE_START_POS - 4] - 0x30) * 1000 + (g_start_dat[MEM_SAVE_START_POS - 3]  -0x30)*100 + (g_start_dat[MEM_SAVE_START_POS - 2] - 0x30)*10 + (g_start_dat[MEM_SAVE_START_POS  -1] - 0x30));
  if( (0x5A != g_start_dat[0]) ||(0x4A != g_start_dat[1]) ||(0x48 != g_start_dat[2]) ||(0x7A != g_start_dat[3])||(('A' != g_start_dat[4]) && ('B' != g_start_dat[4]) ) || ( len > MAX_LEN ) || (len < 0))
  {
        g_start_dat[0] = 0X5A;
        g_start_dat[1] = 0x4A;
        g_start_dat[2] = 0x48;
        g_start_dat[3] = 0x7A;
        g_start_dat[4] = 0X30;//保存A=8路 B=32路
        g_start_dat[5] = 0X30;
        g_start_dat[6] = 0X30;
        g_start_dat[7] = 0x30;
        g_start_dat[8] = 0x30;
        len = 0;
        for(i = 0; i< sizeof(g_start_dat); i++)
        {
              EEPROM.write(i, g_start_dat[i]);
        }
        EEPROM.commit();
  } 
  
  return len;
}
/*
*@brief 清除串口接收计数，串口接收数据长度，串口缓冲区
*param
*param
*/
int8_t clear_var(void)
{  
  delay(50);
  Serial.flush();
  if(rec_cnt > 0)
  {
      memset(rec_cmd, 0 , rec_cnt ); 
  }
  rec_cnt = 0;
  g_rec_dat_len = 0;
  return 1;
}
/*
*@brief 初始化wifi配置
*param
*param
*/
void init_wifi_config()
{
    int connect_times = 0;
    if( (strlen(tmp_data[SSID_POS]) > 1) && (strlen(tmp_data[PASSWORD_POS]) > 1) )
    {
      WiFiMulti.addAP((tmp_data[SSID_POS] + 1 ), (tmp_data[PASSWORD_POS] + 1));
      Serial.println(tmp_data[SSID_POS] + 1);
      Serial.println(tmp_data[PASSWORD_POS] + 1);
     // Serial.println(); 
     // Serial.print("Connecting to Wifi: ");
     // Serial.println(MySSID);  
      pinMode(LED_BUILTIN, OUTPUT); 
      // Waiting for Wifi connect
      while(WiFiMulti.run() != WL_CONNECTED) {
      delay(500);
      connect_times ++;
      if(connect_times > 20)
      {
          g_init_status_flg = 0;
          digitalWrite(LED_BUILTIN, HIGH);
          return ; 
      }
      Serial.print(".");
      }
      if(WiFiMulti.run() == WL_CONNECTED) {
      //  Serial.println("");
      //  Serial.print("WiFi connected. ");
      //  Serial.print("IP address: ");
      //  Serial.println(WiFi.localIP());
      } 
      // server address, port and URL
      webSocket.begin("iot.sinric.com", 80, "/");
      // event handler
      webSocket.onEvent(webSocketEvent);
      webSocket.setAuthorization("apikey", (tmp_data[APIKEY_POS] + 1));
      // try again every 5000ms if connection has failed
      webSocket.setReconnectInterval(5000);   // If you see 'class WebSocketsClient' has no member named 'setReconnectInterval' error update arduinoWebSockets
      Serial.print("RELAY-TEST-NOW");
      digitalWrite(LED_BUILTIN, LOW);
      g_init_status_flg = 1;
    }  
  else
  {
    g_init_status_flg = 0;
    digitalWrite(LED_BUILTIN, HIGH);
  }
    
}
int wait_time = 0;
/*
*@brief 接收串口数据
*param
*/
int32_t read_serial_start()
{
   int array_index = 0;            
   int len = 0;     
   int i = 0; 
   int j = 0;
   int need_to_init = 0;
   char temp[64] = {0};
   char len_temp[5] = {0};
   char* pos_next = NULL;
   char* pos = NULL;
   while (Serial.available()) {     
        char inChar = (char)Serial.read();
        if(rec_cnt >= MAX_REC_LEN)
        {
          //防止越界，否则设备会死机
          rec_cnt = 0;
        }
        rec_cmd[rec_cnt++] = inChar;
        if((GET_REC_LEN) == rec_cnt)
        {
          wait_time = 0;
          if((DELIM == rec_cmd[FIRST_DELIM_POS]) && (DELIM == rec_cmd[SECOND_DELIM_POS]) )
          {
             g_rec_dat_len = (rec_cmd[REC_DATA_LEN_POS] - 0x30)*1000 + (rec_cmd[REC_DATA_LEN_POS + 1] - 0x30)*100 + \
             (rec_cmd[REC_DATA_LEN_POS + 2] - 0x30)*10 + (rec_cmd[REC_DATA_LEN_POS + 3] - 0x30);
             
             if( (0 == g_rec_dat_len) || (g_rec_dat_len >= MAX_REC_LEN) )
             {
              Serial.println("Config-failed");   
              return clear_var();
             }                      
          }
          else
          {   
            Serial.println("Config-failed");
            return clear_var();
          }
        }  
    }
  
    if( (0x31 == rec_cmd[GET_SAVE_POS]) && ('$' == rec_cmd[GET_SAVE_POS + 1]) && ('$' == rec_cmd[GET_SAVE_POS + 2]) )
    {
        len = 0;
        for(i = 0; i < ARRAY_NUM; i++)
        {     
          if(0 == strlen(tmp_data[i]))
          {
            //此处是一个异常，tmp_data里面至少应该有一个，字符
            tmp_data[i][0] = DELIM;   
          }
          len += strlen(tmp_data[i]);
        }
        len = len + 5;
        if( ('A' != g_start_dat[4]) && ('B' != g_start_dat[4]) )
        {
           Serial.println("Read-failed");
           return clear_var();
        }
        if('A' == g_start_dat[4]) 
        {
           Serial.print('A');
        }
        else
        {
           Serial.print('B');
        }
        Serial.print(len/1000);
        Serial.print(len%1000/100);
        Serial.print(len%100/10);
        Serial.print(len%10);
        for(i = 0; i < ARRAY_NUM; i++)
        {
          Serial.print(tmp_data[i]);      
        }
        Serial.println("Read-OK");   
        return clear_var();    
    }
    else if( ((rec_cnt ) == g_rec_dat_len) && (g_rec_dat_len >= (GET_REC_LEN)) )
    {
      //接收完成
       array_index = 0;    
       need_to_init = 0;
       pos = strstr(rec_cmd, ",");
       pos = strstr((pos + 1), ",");
       for(i =0; (i < (g_rec_dat_len) && (NULL != pos)); i = i+ len)
       {     
            pos_next = strstr((pos + 1), ",");
            if(NULL != pos_next)
            {
                len = pos_next - pos;
            }
            else if(NULL != pos)
            {
                len= strlen(pos);
            }
            else
            {
              break;
            }
            if(len > 1)
            {
                if(array_index < 3)
                {
                   memset(temp, 0, sizeof(temp));
                   len = (len > 64)?64:len;
                   memcpy(temp, pos, len);
                   if(0 != strcmp(temp, tmp_data[array_index]))
                   {
                       need_to_init = 1;
                   }
                }
                memset(tmp_data[array_index], 0, ARRAY_DAT_NUM);
                memcpy((tmp_data[array_index]), (pos), (len));  
            }
            array_index++;
            pos = pos_next;
       }  
     g_rec_dat_len = g_rec_dat_len - SECOND_DELIM_POS;
     //这个地方要启动初始化操作
     if(1 == need_to_init)
     {
       init_wifi_config();
     }
     len_temp[0] = rec_cmd[0];
     Serial.println('A');
     Serial.print(rec_cmd[0]);
     if( ('A' != rec_cmd[0]) && ('B' != rec_cmd[0]) )
     {
       Serial.println("Config-failed");
       return clear_var();
     }
     
     len_temp[1] = (g_rec_dat_len )/1000 + 0x30;
     len_temp[2] = (g_rec_dat_len )%1000/100 + 0x30;
     len_temp[3] = (g_rec_dat_len )%100/10 + 0x30;
     len_temp[4] = (g_rec_dat_len )%10 + 0x30;  
     g_start_dat[4] =  rec_cmd[0];
     for(i = 0; i< sizeof(len_temp); i++)
     {
      EEPROM.write(4 +i, len_temp[i]);
     }    
     for(i = 0; i< ARRAY_NUM; i++)
     {
      for(j = 0; j < ARRAY_DAT_NUM; j++)
       {
        EEPROM.write((i*ARRAY_DAT_NUM + j + MEM_SAVE_START_POS) , tmp_data[i][j]);
       }
     }
     EEPROM.commit();      
     Serial.println("Config-OK");  
     return clear_var();     
    }
    
    if( rec_cnt > 0 )
    {              
       wait_time ++;
       if(wait_time > 800)
       {
          wait_time = 0;
          return clear_var();   
       }
    }
    else
    {
        wait_time = 0;  
    }
    delay(1);
    return 0;
}
/*
  从存储空间读取配置参数
*/
void get_config_from_mem()
{
  int16_t i = 0;
  int16_t j = 0;
  EEPROM.begin(MAX_LEN);
  memset(tmp_data, 0, sizeof(tmp_data));  
#if NEED_CLEAR_MEM
  clear_memory();
#endif
  if(getSaveDatLen() <= 0)
  {
    for(i = 0; i < ARRAY_NUM; i++)
    {
        tmp_data[i][0] = DELIM;
    }
  }
  else
  {
    for(i = 0; i < ARRAY_NUM; i++)
    {
    for(j = 0; j < ARRAY_DAT_NUM; j++)
    {
      tmp_data[i][j] = EEPROM.read(i*ARRAY_DAT_NUM + j + MEM_SAVE_START_POS);       
    }
    }
  } 
  return ;
}
int32_t turnOn(String deviceId);
/*
  初始化操作
  如果g_init_status_flg = 1，说明WIFI配置成功，启动WIFI的循环监听
  否认：调用串口接收函数
*/
void setup() {
  g_init_status_flg = 0;
  digitalWrite(LED_BUILTIN, HIGH);
  Serial.begin(SERIAL_RATES);
  get_config_from_mem();
  init_wifi_config();
 }
/*
  循环操作：
  如果g_init_status_flg = 1，说明WIFI配置成功，启动WIFI的循环监听
  否认：调用串口接收函数
*/
void loop() {

  if(g_init_status_flg > 0)
  {
    webSocket.loop();  
    if(isConnected) {
    uint64_t now = millis();
    
    // Send heartbeat in order to avoid disconnections during ISP resetting IPs over night. Thanks @MacSass
    if((now - heartbeatTimestamp) > HEARTBEAT_INTERVAL) {
    heartbeatTimestamp = now;
    webSocket.sendTXT("H");          
    }
    } 
  }
  //串口接收
  read_serial_start();  
}

// If you are going to use a push button to on/off the switch manually, use this function to update the status on the server
// so it will reflect on Alexa app.
// eg: setPowerStateOnServer("deviceid", "ON")

// Call ONLY If status changed. DO NOT CALL THIS IN loop() and overload the server. 

void setPowerStateOnServer(String deviceId, String value) {
  DynamicJsonBuffer jsonBuffer;
  JsonObject& root = jsonBuffer.createObject();
  root["deviceId"] = deviceId;
  root["action"] = "setPowerState";
  root["value"] = value;
  StreamString databuf;
  root.printTo(databuf);
  
  webSocket.sendTXT(databuf);
}
//eg: setPowerStateOnServer("deviceid", "CELSIUS", "25.0")
// Call ONLY If status changed. DO NOT CALL THIS IN loop() and overload the server. 
void setTargetTemperatureOnServer(String deviceId, String value, String scale) {
  DynamicJsonBuffer jsonBuffer;
  JsonObject& root = jsonBuffer.createObject();
  root["action"] = "SetTargetTemperature";
  root["deviceId"] = deviceId;
  
  JsonObject& valueObj = root.createNestedObject("value");
  JsonObject& targetSetpoint = valueObj.createNestedObject("targetSetpoint");
  targetSetpoint["value"] = value;
  targetSetpoint["scale"] = scale;
   
  StreamString databuf;
  root.printTo(databuf);
  
  webSocket.sendTXT(databuf);
}

int32_t turnOn(String deviceId) {
   int32_t i = 0;
   int32_t ret = 0;
   for(i = 0; i < 34; i++)
   {   
     if (ID_EQUAL == strcmp((char*)deviceId.c_str(), &tmp_data[i + RELAY_POS][1])) // Device ID of first device1
     {
       digitalWrite(LED_BUILTIN, LOW);  // Turn the LED off by making the voltage HIGH
     if(i > 31)
     {
         if('A' == g_start_dat[4])
         {
          Serial.println("RELAY-SET_ALL-1,255");
         }
         else if('B' == g_start_dat[4])
         {
          Serial.println("RELAY-SET_ALL-1,255,255,255,255");
         }
         else{
         Serial.print("board type error");
         Serial.println(g_start_dat[4]);
         }
     }
     else
     {
         Serial.print("RELAY-SET-1,");
         Serial.print(i+1);
         Serial.println(",1"); 
     }   
       delay(500);
       ret = 1;
       break;
     }
   }   
   return ret;
}

int32_t turnOff(String deviceId) {
  
   int32_t i = 0;
   int32_t ret = 0;
   for(i = 0; i < 34; i++)
   {     
     if (ID_EQUAL == strcmp((char*)deviceId.c_str(), &tmp_data[i + RELAY_POS][1])) // Device ID of first device1
     {
     if(i > 31)
     {
         digitalWrite(LED_BUILTIN, HIGH); 
         if('A' == g_start_dat[4])
         {
          Serial.println("RELAY-SET_ALL-1,0");
         }
         else if('B' == g_start_dat[4])
         {
          Serial.println("RELAY-SET_ALL-1,0,0,0,0");
         }
         else{
         Serial.print("board type error");
         Serial.println(g_start_dat[4]);
         }
     }
     else
     {
         digitalWrite(LED_BUILTIN, HIGH);  // Turn the LED off by making the voltage HIGH
         Serial.print("RELAY-SET-1,");
         Serial.print(i+1);
         Serial.println(",0");       
     }
    delay(500);
    ret  = 1;
    break;
     }
   }
   return ret;   
}

void webSocketEvent(WStype_t type, uint8_t * payload, size_t length) {
  switch(type) {
    case WStype_DISCONNECTED:
      isConnected = false;    
   //   Serial.printf("[WSc] Webservice disconnected from sinric.com!\n");
      break;
    case WStype_CONNECTED: {
      isConnected = true;
  //    Serial.printf("[WSc] Service connected to sinric.com at url: %s\n", payload);
  //    Serial.printf("Waiting for commands from sinric.com ...\n");        
      }
      break;
    case WStype_TEXT: {
 //       Serial.printf("[WSc] get text: %s\n", payload);
        // Example payloads

        // For Switch or Light device types
        // {"deviceId": xxxx, "action": "setPowerState", value: "ON"} // https://developer.amazon.com/docs/device-apis/alexa-powercontroller.html

        // For Light device type
        // Look at the light example in github
          
        DynamicJsonBuffer jsonBuffer;
        JsonObject& json = jsonBuffer.parseObject((char*)payload); 
        String deviceId = json ["deviceId"];     
        String action = json ["action"];
        
        if(action == "setPowerState") { // Switch or Light
            String value = json ["value"];
            if(value == "ON") {
                if(0 == turnOn(deviceId))
        {
          Serial.println("deviceId is not found");
        }
            } else {
                if(0 == turnOff(deviceId))
        {
          Serial.println("deviceId is not found");
        }
            }
        }
        else if (action == "SetTargetTemperature") {
            String deviceId = json ["deviceId"];     
            String action = json ["action"];
            String value = json ["value"];
        }
        else if (action == "test") {
  //          Serial.println("[WSc] received test command from sinric.com");
        }
      }
      break;
    case WStype_BIN:
 //     Serial.printf("[WSc] get binary length: %u\n", length);
      break;
  }
}
