#include "esphome.h"

#define TAG "kc868"

class KC868BinaryComponent : public Component, public BinarySensor {
  private:
  uint8_t k;

  public:
  KC868BinaryComponent(uint8_t k) : Component() {
    
    this->k = k;
  }

};

class KC868SwitchComponent : public Component {
  private:
  UARTComponent *uartComponent;

  public:
  KC868SwitchComponent(UARTComponent *uartComponent) : Component() {
    this->uartComponent = uartComponent;
  }

};

class KC868Component : public Component, public UARTDevice {
  private:

  public:
  KC868BinaryComponent *kc868BinaryComponents[6];
  KC868Component(UARTComponent *uartComponent) : UARTDevice(uartComponent) {
    for (uint8_t i = 0; i < 6; i++) {
      this->kc868BinaryComponents[i] = new KC868BinaryComponent(i);
    }
  }

  void setup() override {
  }

  void loop() override {
    while(available() >= 21) {
      uint8_t data[21];
      for (int i = 0; i <= 20; i++) {
        uint8_t c = read();
        data[i] = c;
      }

      ESP_LOGD(TAG, "uart bus receive %x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x",
      data[0], data[1], data[2], data[3], data[4],
      data[5], data[6], data[7], data[8], data[9],
      data[10], data[11], data[12], data[13], data[14],
      data[15], data[16], data[17], data[18], data[19],
      data[20], data[21]);

      if (data[7] != 0 && data[8] == 1) {
        this->kc868BinaryComponents[0]->publish_state(true);
        this->kc868BinaryComponents[0]->publish_state(false);
      }

      if (data[9] != 0 && data[10] == 1) {
        this->kc868BinaryComponents[1]->publish_state(true);
        this->kc868BinaryComponents[1]->publish_state(false);
      }

      if (data[11] != 0 && data[12] == 1) {
        this->kc868BinaryComponents[2]->publish_state(true);
        this->kc868BinaryComponents[2]->publish_state(false);
      }

      if (data[13] != 0 && data[14] == 1) {
        this->kc868BinaryComponents[3]->publish_state(true);
        this->kc868BinaryComponents[3]->publish_state(false);
      }

      if (data[15] != 0 && data[16] == 1) {
        this->kc868BinaryComponents[4]->publish_state(true);
        this->kc868BinaryComponents[4]->publish_state(false);
      }

      if (data[17] != 0 && data[18] == 1) {
        this->kc868BinaryComponents[5]->publish_state(true);
        this->kc868BinaryComponents[5]->publish_state(false);
      }
    }
  }
};
