#include "kc868_component.h"
#include "math.h"

namespace esphome {
namespace kc868_component {

void KC868Component::setup() {
    ESP_LOGD(TAG, "KC868Component::setup");
}

void KC868Component::loop() {
    while(available() >= 21) {
        uint8_t data[21];
        for (int i = 0; i <= 20; i++) {
            uint8_t c = read();
            data[i] = c;
        }

        ESP_LOGD(TAG, "uart bus receive %x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x",
        data[0], data[1], data[2], data[3], data[4],
        data[5], data[6], data[7], data[8], data[9],
        data[10], data[11], data[12], data[13], data[14],
        data[15], data[16], data[17], data[18], data[19],
        data[20], data[21]);

        uint8_t crc_data[19] =  {
            data[0],data[1],data[2],data[3],
            data[4],data[5],data[6],data[7],
            data[8],data[9],data[10],data[11],
            data[12],data[13],data[14],data[15],
            data[16],data[17],data[18]};
        uint16_t crc = crc16(crc_data, sizeof(crc_data));

        if ((data[19] != (crc & 0x00FF)) && (data[19] != ((crc & 0xFF00) >> 8))) {
            ESP_LOGD(TAG, "crc check failed. ignore data");
            
            while(available() > 0) {
                read();
            }
            
            return;
        }

        for (auto & element : this->binary_sensors_) 
        {
            if (element->get_addr() == data[0]) {
                if (data[7] == 1 && data[8] == 1 && element->get_key() == 1) {
                    element->publish_state(true);
                    element->publish_state(false);
                }
                if (data[9] == 2 && data[10] == 1 && element->get_key() == 2) {
                    element->publish_state(true);
                    element->publish_state(false);
                }
                if (data[11] == 3 && data[12] == 1 && element->get_key() == 3) {
                    element->publish_state(true);
                    element->publish_state(false);
                }
                if (data[13] == 4 && data[14] == 1 && element->get_key() == 4) {
                    element->publish_state(true);
                    element->publish_state(false);
                }
                if (data[15] == 5 && data[16] == 1 && element->get_key() == 5) {
                    element->publish_state(true);
                    element->publish_state(false);
                }
                if (data[17] == 6 && data[18] == 1 && element->get_key() == 6) {
                    element->publish_state(true);
                    element->publish_state(false);
                }
            }
        }

    }
    
}

void KC868Component::dump_config(){
    ESP_LOGCONFIG(TAG, "KC868Component::dump_config");
}

void KC868BinarySensor::setup() {
    ESP_LOGD(TAG, "KC868BinarySensor::setup");
    this->publish_state(false);
}
void KC868BinarySensor::dump_config(){
    ESP_LOGCONFIG(TAG, "KC868BinarySensor::dump_config");
}

void KC868Switch::setup() {
    ESP_LOGD(TAG, "KC868Switch::setup");
}
void KC868Switch::dump_config(){
    ESP_LOGCONFIG(TAG, "KC868Switch::dump_config");
}

void KC868Switch::write_state(bool state) {

    uint8_t data[9] = {  this->get_addr(), 0x03, 0x06, 0x55, 0xAA, 0x00, 0x00, 0x00, 0x00 };
    uint8_t d = 0;
    for (auto & element : *(this->switches_)) {
        if ((element->get_addr() == this->get_addr()) && (element->get_channel() != this->get_channel())) {
            if (element->state == true) {
                d = d + pow(2,(element->get_channel() - 1));
            }
        }
    }

    if (state == true) {
        d = d + pow(2,(this->get_channel() - 1));
    }

    data[8] = d;
    uint16_t crc = crc16(data, sizeof(data));
    uint8_t uart_data[11] = {data[0],data[1],data[2],data[3],
        data[4],data[5],data[6],data[7],
        data[8],(crc & 0x00FF), (crc & 0xFF00) >> 8};

    this->uart_->write_array(uart_data, sizeof(uart_data));

    ESP_LOGD(TAG, "uart bus send %x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x",
        uart_data[0], uart_data[1], uart_data[2], uart_data[3], uart_data[4],
        uart_data[5], uart_data[6], uart_data[7], uart_data[8], uart_data[9],
        uart_data[10]);

    this->publish_state(state);
}

uint16_t crc16(uint8_t *data, uint8_t length) {
    uint16_t crc = 0xFFFF;

    for (uint8_t i = 0; i < length; i++) {
        crc ^= data[i];
        for (uint8_t j = 8; j > 0; j--) {
            if (crc & 0x0001) {
                crc = (crc >> 1) ^ 0xA001;
            } else {
                crc >>= 1;
            }
        }
    }

    return crc;
}

}
}