import esphome.codegen as cg
import esphome.config_validation as cv
from esphome.components import binary_sensor
from esphome.const import CONF_ID
from . import Kc868Component, KC868_ID

DEPENDENCIES = ['kc868_component']

binary_sensor_ns = cg.esphome_ns.namespace('kc868_component')
BinarySensor = binary_sensor_ns.class_('KC868BinarySensor', binary_sensor.BinarySensor)

CONFIG_SCHEMA = binary_sensor.BINARY_SENSOR_SCHEMA.extend({
    cv.GenerateID(): cv.declare_id(BinarySensor),
    cv.GenerateID(KC868_ID): cv.use_id(Kc868Component),
    cv.Required("addr"): cv.int_,
    cv.Required("key"): cv.int_range(min=1, max=6),
}).extend(cv.COMPONENT_SCHEMA)

def to_code(config):
    paren = yield cg.get_variable(config[KC868_ID])
    var = cg.new_Pvariable(config[CONF_ID])
    yield binary_sensor.register_binary_sensor(var, config)
    cg.add(var.set_addr(config["addr"]))
    cg.add(var.set_key(config["key"]))
    cg.add(paren.register_binary_sensor(var))