
////////////////////////////////////
//   DEVICE-SPECIFIC LED SERVICES //
////////////////////////////////////

#include "extras/PwmPin.h"                          // library of various PWM functions
#include "PCF8574.h"
////////////////////////////////////

extern PCF8574 pcfIN_1;
extern PCF8574 pcfIN_2;
extern PCF8574 pcfOUT_1;
extern PCF8574 pcfOUT_2;

#define RELAY1  1
#define RELAY2  2
#define RELAY3  3
#define RELAY4  4
#define RELAY5  5
#define RELAY6  6
#define RELAY7  7
#define RELAY8  8
#define RELAY9  9
#define RELAY10  10
#define RELAY11  11
#define RELAY12  12
#define RELAY13  13
#define RELAY14  14
#define RELAY15  15
#define RELAY16  16


#define INPUT1  1
#define INPUT2  2
#define INPUT3  3
#define INPUT4  4
#define INPUT5  5
#define INPUT6  6
#define INPUT7  7
#define INPUT8  8
#define INPUT9  9
#define INPUT10  10
#define INPUT11  11
#define INPUT12  12
#define INPUT13  13
#define INPUT14  14
#define INPUT15  15
#define INPUT16  16


boolean PCF_READ(int mPin) {
  if(mPin<9)
    return  pcfIN_1.digitalRead(mPin-1);
  else
    return  pcfIN_2.digitalRead(mPin-9);
}
void PCF_WRITE(int mPin, boolean value ) {
  if(mPin<9)
    pcfOUT_1.digitalWrite((mPin-1),value);
  else
    pcfOUT_2.digitalWrite((mPin-9),value);
}


struct DEV_DimmableLED : Service::LightBulb {       // Dimmable LED

  //LedPin *ledPin;                                   // reference to Led Pin
  int powerPin;                                     // NEW! pin with pushbutton to turn on/off LED
  int ledPin;
  SpanCharacteristic *power;                        // reference to the On Characteristic
  SpanCharacteristic *level;                        // reference to the Brightness Characteristic
  int favoriteLevel=50;                             // NEW! keep track of a 'favorite' level
  // NEW!  Consructor includes 3 additional arguments to specify pin numbers for power, raise, and lower buttons
  
  DEV_DimmableLED(int pin, int powerPin) : Service::LightBulb(){

    power=new Characteristic::On();     
    //new SpanButton(powerPin);                       // NEW! create new SpanButton to control power using pushbutton on pin number "powerPin"
    new SpanButton(powerPin,PCF_READ);

    this->powerPin=powerPin;                        // NEW! save power pushbutton pin number

    //this->ledPin=new LedPin(pin);                   // configures a PWM LED for output to the specified pin
    this->ledPin=pin;
    
    Serial.print("Configuring Dimmable LED: Pin="); // initialization message
    Serial.print(pin);
    Serial.print("\n");
    
  } // end constructor


  


  boolean update(){                              // update() method

    if(power->updated()){
      LOG1("  New Power=");
      LOG1(power->getNewVal()?"true":"false");
    }

    LOG1("\n");
    //ledPin->set(power->getNewVal()*100);    
    PCF_WRITE(ledPin,power->getNewVal());
    return(true);                               // return true
  
  } // update

  // NEW!  Here is the button() method where all the PushButton actions are defined.   Take note of the signature, and use of the word "override" 

  void button(int pin, int pressType) override {

    int newLevel;

    if(pin==powerPin){
      if(pressType==SpanButton::SINGLE){            // if a SINGLE press of the power button...
        power->setVal(1-power->getVal());           // ...toggle the value of the power Characteristic
      }       
    } 
    
    //ledPin->set(power->getVal()*100);       // update the physical LED to reflect the new values
    PCF_WRITE(ledPin,power->getNewVal());
  }

};
