/********************************************************************
 * Create Your own Ethernet-WebServer for KC868-A32 Smart Controller*
 * https://www.kincony.com                                ***********
*********************************************************************/
#include <ETH.h> 

#include "PCF8574.h"
#define DEBUG_ETHERNET_WEBSERVER_PORT       Serial

// Debug Level from 0 to 4
#define _ETHERNET_WEBSERVER_LOGLEVEL_       3

#include <WebServer_WT32_ETH01.h>

#define ETH_ADDR        0
#define ETH_POWER_PIN  -1
#define ETH_MDC_PIN    23
#define ETH_MDIO_PIN   18
#define ETH_TYPE       ETH_PHY_LAN8720
#define ETH_CLK_MODE   ETH_CLOCK_GPIO17_OUT

WiFiServer server(80);


// Select the IP address according to your local network
IPAddress myIP(192, 168, 1, 232);
IPAddress myGW(192, 168, 1, 1);
IPAddress mySN(255, 255, 255, 0);

// Google DNS Server IP
IPAddress myDNS(8, 8, 8, 8);

// Current time
unsigned long currentTime = millis();
// Previous time
unsigned long previousTime = 0; 
// Define timeout time in milliseconds (example: 2000ms = 2s)
const long timeoutTime = 2000;

int flag_read_di=0;

// Variable to store the HTTP request
String header;

TwoWire I2Cone = TwoWire(0);
//TwoWire I2Ctwo = TwoWire(1);

// Set relay output i2c address
PCF8574 pcf8574_R1(&I2Cone, 0x24, 4, 5);
PCF8574 pcf8574_R2(&I2Cone, 0x25, 4, 5);
//PCF8574 pcf8574_R3(&I2Ctwo, 0x21, 15, 13);
//PCF8574 pcf8574_R4(&I2Ctwo, 0x22, 15, 13);

// Set digital input i2c address
PCF8574 pcf8574_I1(&I2Cone, 0x21, 4, 5);
PCF8574 pcf8574_I2(&I2Cone, 0x22, 4, 5);
//PCF8574 pcf8574_I3(&I2Cone, 0x21, 4, 5);
//PCF8574 pcf8574_I4(&I2Cone, 0x22, 4, 5);


String relay1state = "off";// state of relay1
String relay2state = "off";// state of relay2
String relay3state = "off";// state of relay3
String relay4state = "off";// state of relay4
String relay5state = "off";// state of relay5
String relay6state = "off";// state of relay6
String relay7state = "off";// state of relay7
String relay8state = "off";// state of relay8

String relay9state = "off";// state of relay9
String relay10state = "off";// state of relay10
String relay11state = "off";// state of relay11
String relay12state = "off";// state of relay12
String relay13state = "off";// state of relay13
String relay14state = "off";// state of relay14
String relay15state = "off";// state of relay15
String relay16state = "off";// state of relay16
/*
String relay17state = "off";// state of relay17
String relay18state = "off";// state of relay18
String relay19state = "off";// state of relay19
String relay20state = "off";// state of relay20
String relay21state = "off";// state of relay21
String relay22state = "off";// state of relay22
String relay23state = "off";// state of relay23
String relay24state = "off";// state of relay24

String relay25state = "off";// state of relay25
String relay26state = "off";// state of relay26
String relay27state = "off";// state of relay27
String relay28state = "off";// state of relay28
String relay29state = "off";// state of relay29
String relay30state = "off";// state of relay30
String relay31state = "off";// state of relay31
String relay32state = "off";// state of relay32*/


void setup()
{
  Serial.begin(115200);

  // Set PCF8574 pinMode to OUTPUT
 pcf8574_R1.pinMode(P0, OUTPUT);
 pcf8574_R1.pinMode(P1, OUTPUT);
 pcf8574_R1.pinMode(P2, OUTPUT);
 pcf8574_R1.pinMode(P3, OUTPUT);
 pcf8574_R1.pinMode(P4, OUTPUT);
 pcf8574_R1.pinMode(P5, OUTPUT);
 pcf8574_R1.pinMode(P6, OUTPUT);
 pcf8574_R1.pinMode(P7, OUTPUT);

 pcf8574_R2.pinMode(P0, OUTPUT);
 pcf8574_R2.pinMode(P1, OUTPUT);
 pcf8574_R2.pinMode(P2, OUTPUT);
 pcf8574_R2.pinMode(P3, OUTPUT);
 pcf8574_R2.pinMode(P4, OUTPUT);
 pcf8574_R2.pinMode(P5, OUTPUT);
 pcf8574_R2.pinMode(P6, OUTPUT);
 pcf8574_R2.pinMode(P7, OUTPUT);
/*
 pcf8574_R3.pinMode(P0, OUTPUT);
 pcf8574_R3.pinMode(P1, OUTPUT);
 pcf8574_R3.pinMode(P2, OUTPUT);
 pcf8574_R3.pinMode(P3, OUTPUT);
 pcf8574_R3.pinMode(P4, OUTPUT);
 pcf8574_R3.pinMode(P5, OUTPUT);
 pcf8574_R3.pinMode(P6, OUTPUT);
 pcf8574_R3.pinMode(P7, OUTPUT);

 pcf8574_R4.pinMode(P0, OUTPUT);
 pcf8574_R4.pinMode(P1, OUTPUT);
 pcf8574_R4.pinMode(P2, OUTPUT);
 pcf8574_R4.pinMode(P3, OUTPUT);
 pcf8574_R4.pinMode(P4, OUTPUT);
 pcf8574_R4.pinMode(P5, OUTPUT);
 pcf8574_R4.pinMode(P6, OUTPUT);
 pcf8574_R4.pinMode(P7, OUTPUT);*/

  Serial.print("Init pcf8574_R1...");
  if (pcf8574_R1.begin()){
    Serial.println("PCF8574_R1_OK");
  }else{
    Serial.println("PCF8574_R1_KO");
  }

  Serial.print("Init pcf8574_R2...");
  if (pcf8574_R2.begin()){
    Serial.println("PCF8574_R2_OK");
  }else{
    Serial.println("PCF8574_R2_KO");
  }
/*
  Serial.print("Init pcf8574_R3...");
  if (pcf8574_R3.begin()){
    Serial.println("PCF8574_R3_OK");
  }else{
    Serial.println("PCF8574_R3_KO");
  }

  Serial.print("Init pcf8574_R4...");
  if (pcf8574_R4.begin()){
    Serial.println("PCF8574_R4_OK");
  }else{
    Serial.println("PCF8574_R4_KO");
  }*/
//--------------------------------------
 pcf8574_I1.pinMode(P0, INPUT);
 pcf8574_I1.pinMode(P1, INPUT);
 pcf8574_I1.pinMode(P2, INPUT);
 pcf8574_I1.pinMode(P3, INPUT);
 pcf8574_I1.pinMode(P4, INPUT);
 pcf8574_I1.pinMode(P5, INPUT);
 pcf8574_I1.pinMode(P6, INPUT);
 pcf8574_I1.pinMode(P7, INPUT);

 pcf8574_I2.pinMode(P0, INPUT);
 pcf8574_I2.pinMode(P1, INPUT);
 pcf8574_I2.pinMode(P2, INPUT);
 pcf8574_I2.pinMode(P3, INPUT);
 pcf8574_I2.pinMode(P4, INPUT);
 pcf8574_I2.pinMode(P5, INPUT);
 pcf8574_I2.pinMode(P6, INPUT);
 pcf8574_I2.pinMode(P7, INPUT);
/*
 pcf8574_I3.pinMode(P0, INPUT);
 pcf8574_I3.pinMode(P1, INPUT);
 pcf8574_I3.pinMode(P2, INPUT);
 pcf8574_I3.pinMode(P3, INPUT);
 pcf8574_I3.pinMode(P4, INPUT);
 pcf8574_I3.pinMode(P5, INPUT);
 pcf8574_I3.pinMode(P6, INPUT);
 pcf8574_I3.pinMode(P7, INPUT);

 pcf8574_I4.pinMode(P0, INPUT);
 pcf8574_I4.pinMode(P1, INPUT);
 pcf8574_I4.pinMode(P2, INPUT);
 pcf8574_I4.pinMode(P3, INPUT);
 pcf8574_I4.pinMode(P4, INPUT);
 pcf8574_I4.pinMode(P5, INPUT);
 pcf8574_I4.pinMode(P6, INPUT);
 pcf8574_I4.pinMode(P7, INPUT);*/

  Serial.print("Init pcf8574...");
  if (pcf8574_I1.begin()){
    Serial.println("pcf8574_I1_OK");
  }else{
    Serial.println("pcf8574_I1_KO");
  }

  Serial.print("Init pcf8574...");
  if (pcf8574_I2.begin()){
    Serial.println("pcf8574_I2_OK");
  }else{
    Serial.println("pcf8574_I2_KO");
  }
/*
  Serial.print("Init pcf8574_I3...");
  if (pcf8574_I3.begin()){
    Serial.println("pcf8574_I3_OK");
  }else{
    Serial.println("pcf8574_I3_KO");
  }

  Serial.print("Init pcf8574_I4...");
  if (pcf8574_I4.begin()){
    Serial.println("pcf8574_I4_OK");
  }else{
    Serial.println("pcf8574_I4_KO");
  }*/

  
//-------------------------------------
  pcf8574_R1.digitalWrite(P0, HIGH);
  pcf8574_R1.digitalWrite(P1, HIGH);
  pcf8574_R1.digitalWrite(P2, HIGH);
  pcf8574_R1.digitalWrite(P3, HIGH);
  pcf8574_R1.digitalWrite(P4, HIGH);
  pcf8574_R1.digitalWrite(P5, HIGH);
  pcf8574_R1.digitalWrite(P6, HIGH);
  pcf8574_R1.digitalWrite(P7, HIGH);

  pcf8574_R2.digitalWrite(P0, HIGH);
  pcf8574_R2.digitalWrite(P1, HIGH);
  pcf8574_R2.digitalWrite(P2, HIGH);
  pcf8574_R2.digitalWrite(P3, HIGH);
  pcf8574_R2.digitalWrite(P4, HIGH);
  pcf8574_R2.digitalWrite(P5, HIGH);
  pcf8574_R2.digitalWrite(P6, HIGH);
  pcf8574_R2.digitalWrite(P7, HIGH);
/* 
  pcf8574_R3.digitalWrite(P0, HIGH);
  pcf8574_R3.digitalWrite(P1, HIGH);
  pcf8574_R3.digitalWrite(P2, HIGH);
  pcf8574_R3.digitalWrite(P3, HIGH);
  pcf8574_R3.digitalWrite(P4, HIGH);
  pcf8574_R3.digitalWrite(P5, HIGH);
  pcf8574_R3.digitalWrite(P6, HIGH);
  pcf8574_R3.digitalWrite(P7, HIGH);

  pcf8574_R4.digitalWrite(P0, HIGH);
  pcf8574_R4.digitalWrite(P1, HIGH);
  pcf8574_R4.digitalWrite(P2, HIGH);
  pcf8574_R4.digitalWrite(P3, HIGH);
  pcf8574_R4.digitalWrite(P4, HIGH);
  pcf8574_R4.digitalWrite(P5, HIGH);
  pcf8574_R4.digitalWrite(P6, HIGH);
  pcf8574_R4.digitalWrite(P7, HIGH);*/

  
  while (!Serial);

  // Using this if Serial debugging is not necessary or not using Serial port
  //while (!Serial && (millis() < 3000));

  Serial.print("\nStarting WebServer on " + String(ARDUINO_BOARD));
  Serial.println(" with " + String(SHIELD_TYPE));
  Serial.println(WEBSERVER_WT32_ETH01_VERSION);

  // To be called before ETH.begin()
  WT32_ETH01_onEvent();

  //bool begin(uint8_t phy_addr=ETH_PHY_ADDR, int power=ETH_PHY_POWER, int mdc=ETH_PHY_MDC, int mdio=ETH_PHY_MDIO, 
  //           eth_phy_type_t type=ETH_PHY_TYPE, eth_clock_mode_t clk_mode=ETH_CLK_MODE);
  ETH.begin(ETH_PHY_ADDR, ETH_PHY_POWER, ETH_PHY_MDC, ETH_PHY_MDIO, ETH_PHY_TYPE, ETH_CLK_MODE);
  ETH.begin(ETH_PHY_ADDR, ETH_PHY_POWER);

  // Static IP, leave without this line to get IP via DHCP
  //bool config(IPAddress local_ip, IPAddress gateway, IPAddress subnet, IPAddress dns1 = 0, IPAddress dns2 = 0);
  ETH.config(myIP, myGW, mySN, myDNS);

  WT32_ETH01_waitForConnect();

  // start the web server on port 80
  server.begin();
}

void loop()
{
  // listen for incoming clients
  WiFiClient client = server.available();

  if (client) {                             // If a new client connects,
    Serial.println("New Client.");          // print a message out in the serial port
    String currentLine = "";                // make a String to hold incoming data from the client
    currentTime = millis();
    previousTime = currentTime;
    while (client.connected() && currentTime - previousTime <= timeoutTime) { // loop while the client's connected
      currentTime = millis();         
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
        Serial.write(c);                    // print it out the serial monitor
        header += c;
        if (c == '\n') {                    // if the byte is a newline character
          // if the current line is blank, you got two newline characters in a row.
          // that's the end of the client HTTP request, so send a response:
          if (currentLine.length() == 0) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println("Connection: close");
            client.println();

          

            
            // turns 32 relays on and off
            if (header.indexOf("GET /1/on") >= 0) {relay1state = "on";pcf8574_R1.digitalWrite(P0, LOW);}
            else if (header.indexOf("GET /1/off") >= 0) {relay1state = "off";pcf8574_R1.digitalWrite(P0, HIGH);}
            else if (header.indexOf("GET /2/on") >= 0)  {relay2state = "on";pcf8574_R1.digitalWrite(P1, LOW);}
            else if (header.indexOf("GET /2/off") >= 0) {relay2state = "off";pcf8574_R1.digitalWrite(P1, HIGH);}
            else if (header.indexOf("GET /3/on") >= 0)  {relay3state = "on";pcf8574_R1.digitalWrite(P2, LOW);}
            else if (header.indexOf("GET /3/off") >= 0) {relay3state = "off";pcf8574_R1.digitalWrite(P2, HIGH);}         
            else if (header.indexOf("GET /4/on") >= 0)  {relay4state = "on";pcf8574_R1.digitalWrite(P3, LOW);}
            else if (header.indexOf("GET /4/off") >= 0) {relay4state = "off";pcf8574_R1.digitalWrite(P3, HIGH);}
            else if (header.indexOf("GET /5/on") >= 0)  {relay5state = "on";pcf8574_R1.digitalWrite(P4, LOW);}
            else if (header.indexOf("GET /5/off") >= 0) {relay5state = "off";pcf8574_R1.digitalWrite(P4, HIGH);}
            else if (header.indexOf("GET /6/on") >= 0)  {relay6state = "on";pcf8574_R1.digitalWrite(P5, LOW);}
            else if (header.indexOf("GET /6/off") >= 0) {relay6state = "off";pcf8574_R1.digitalWrite(P5, HIGH);}          
            else if (header.indexOf("GET /7/on") >= 0)  {relay7state = "on";pcf8574_R1.digitalWrite(P6, LOW);}
            else if (header.indexOf("GET /7/off") >= 0) {relay7state = "off";pcf8574_R1.digitalWrite(P6, HIGH);}
            else if (header.indexOf("GET /8/on") >= 0)  {relay8state = "on";pcf8574_R1.digitalWrite(P7, LOW);}
            else if (header.indexOf("GET /8/off") >= 0) {relay8state = "off";pcf8574_R1.digitalWrite(P7, HIGH);}
            else if (header.indexOf("GET /9/on") >= 0)  {relay9state = "on";pcf8574_R2.digitalWrite(P0, LOW);}
            else if (header.indexOf("GET /9/off") >= 0) {relay9state = "off";pcf8574_R2.digitalWrite(P0, HIGH);}         
            else if (header.indexOf("GET /10/on") >= 0)  {relay10state = "on";pcf8574_R2.digitalWrite(P1, LOW);}
            else if (header.indexOf("GET /10/off") >= 0) {relay10state = "off";pcf8574_R2.digitalWrite(P1, HIGH);}
            else if (header.indexOf("GET /11/on") >= 0)  {relay11state = "on";pcf8574_R2.digitalWrite(P2, LOW);}
            else if (header.indexOf("GET /11/off") >= 0) {relay11state = "off";pcf8574_R2.digitalWrite(P2, HIGH);}
            else if (header.indexOf("GET /12/on") >= 0)  {relay12state = "on";pcf8574_R2.digitalWrite(P3, LOW);}
            else if (header.indexOf("GET /12/off") >= 0) {relay12state = "off";pcf8574_R2.digitalWrite(P3, HIGH);}
            else if (header.indexOf("GET /13/on") >= 0)  {relay13state = "on";pcf8574_R2.digitalWrite(P4, LOW);}
            else if (header.indexOf("GET /13/off") >= 0) {relay13state = "off";pcf8574_R2.digitalWrite(P4, HIGH);}
            else if (header.indexOf("GET /14/on") >= 0)  {relay14state = "on";pcf8574_R2.digitalWrite(P5, LOW);}
            else if (header.indexOf("GET /14/off") >= 0) {relay14state = "off";pcf8574_R2.digitalWrite(P5, HIGH);}
            else if (header.indexOf("GET /15/on") >= 0)  {relay15state = "on";pcf8574_R2.digitalWrite(P6, LOW);}
            else if (header.indexOf("GET /15/off") >= 0) {relay15state = "off";pcf8574_R2.digitalWrite(P6, HIGH);}
            else if (header.indexOf("GET /16/on") >= 0)  {relay16state = "on";pcf8574_R2.digitalWrite(P7, LOW);}
            else if (header.indexOf("GET /16/off") >= 0) {relay16state = "off";pcf8574_R2.digitalWrite(P7, HIGH);}
     /*       else if (header.indexOf("GET /17/on") >= 0)  {relay17state = "on";pcf8574_R3.digitalWrite(P0, LOW);}
            else if (header.indexOf("GET /17/off") >= 0) {relay17state = "off";pcf8574_R3.digitalWrite(P0, HIGH);}
            else if (header.indexOf("GET /18/on") >= 0)  {relay18state = "on";pcf8574_R3.digitalWrite(P1, LOW);}
            else if (header.indexOf("GET /18/off") >= 0) {relay18state = "off";pcf8574_R3.digitalWrite(P1, HIGH);}
            else if (header.indexOf("GET /19/on") >= 0)  {relay19state = "on";pcf8574_R3.digitalWrite(P2, LOW);}
            else if (header.indexOf("GET /19/off") >= 0) {relay19state = "off";pcf8574_R3.digitalWrite(P2, HIGH);}
            else if (header.indexOf("GET /20/on") >= 0)  {relay20state = "on";pcf8574_R3.digitalWrite(P3, LOW);}
            else if (header.indexOf("GET /20/off") >= 0) {relay20state = "off";pcf8574_R3.digitalWrite(P3, HIGH);}
            else if (header.indexOf("GET /21/on") >= 0)  {relay21state = "on";pcf8574_R3.digitalWrite(P4, LOW);}
            else if (header.indexOf("GET /21/off") >= 0) {relay21state = "off";pcf8574_R3.digitalWrite(P4, HIGH);}
            else if (header.indexOf("GET /22/on") >= 0)  {relay22state = "on";pcf8574_R3.digitalWrite(P5, LOW);}
            else if (header.indexOf("GET /22/off") >= 0) {relay22state = "off";pcf8574_R3.digitalWrite(P5, HIGH);}
            else if (header.indexOf("GET /23/on") >= 0)  {relay23state = "on";pcf8574_R3.digitalWrite(P6, LOW);}
            else if (header.indexOf("GET /23/off") >= 0) {relay23state = "off";pcf8574_R3.digitalWrite(P6, HIGH);}
            else if (header.indexOf("GET /24/on") >= 0)  {relay24state = "on";pcf8574_R3.digitalWrite(P7, LOW);}
            else if (header.indexOf("GET /24/off") >= 0) {relay24state = "off";pcf8574_R3.digitalWrite(P7, HIGH);}
            else if (header.indexOf("GET /25/on") >= 0)  {relay25state = "on";pcf8574_R4.digitalWrite(P0, LOW);}
            else if (header.indexOf("GET /25/off") >= 0) {relay25state = "off";pcf8574_R4.digitalWrite(P0, HIGH);}
            else if (header.indexOf("GET /26/on") >= 0)  {relay26state = "on";pcf8574_R4.digitalWrite(P1, LOW);}
            else if (header.indexOf("GET /26/off") >= 0) {relay26state = "off";pcf8574_R4.digitalWrite(P1, HIGH);}
            else if (header.indexOf("GET /27/on") >= 0)  {relay27state = "on";pcf8574_R4.digitalWrite(P2, LOW);}
            else if (header.indexOf("GET /27/off") >= 0) {relay27state = "off";pcf8574_R4.digitalWrite(P2, HIGH);}
            else if (header.indexOf("GET /28/on") >= 0)  {relay28state = "on";pcf8574_R4.digitalWrite(P3, LOW);}
            else if (header.indexOf("GET /28/off") >= 0) {relay28state = "off";pcf8574_R4.digitalWrite(P3, HIGH);}
            else if (header.indexOf("GET /29/on") >= 0)  {relay29state = "on";pcf8574_R4.digitalWrite(P4, LOW);}
            else if (header.indexOf("GET /29/off") >= 0) {relay29state = "off";pcf8574_R4.digitalWrite(P4, HIGH);}
            else if (header.indexOf("GET /30/on") >= 0)  {relay30state = "on";pcf8574_R4.digitalWrite(P5, LOW);}
            else if (header.indexOf("GET /30/off") >= 0) {relay30state = "off";pcf8574_R4.digitalWrite(P5, HIGH);}
            else if (header.indexOf("GET /31/on") >= 0)  {relay31state = "on";pcf8574_R4.digitalWrite(P6, LOW);}
            else if (header.indexOf("GET /31/off") >= 0) {relay31state = "off";pcf8574_R4.digitalWrite(P6, HIGH);}
            else if (header.indexOf("GET /32/on") >= 0)  {relay32state = "on";pcf8574_R4.digitalWrite(P7, LOW);}
            else if (header.indexOf("GET /32/off") >= 0) {relay32state = "off";pcf8574_R4.digitalWrite(P7, HIGH);}*/
            else if (header.indexOf("GET /read") >= 0) flag_read_di=1;
            else if (header.indexOf("GET /all/on") >= 0)
            {
              relay1state = "on";// state of relay1
              relay2state = "on";// state of relay2
              relay3state = "on";// state of relay3
              relay4state = "on";// state of relay4
              relay5state = "on";// state of relay5
              relay6state = "on";// state of relay6
              relay7state = "on";// state of relay7
              relay8state = "on";// state of relay8

              relay9state = "on";// state of relay9
              relay10state = "on";// state of relay10
              relay11state = "on";// state of relay11
              relay12state = "on";// state of relay12
              relay13state = "on";// state of relay13
              relay14state = "on";// state of relay14
              relay15state = "on";// state of relay15
              relay16state = "on";// state of relay16
/*
              relay17state = "on";// state of relay17
              relay18state = "on";// state of relay18
              relay19state = "on";// state of relay19
              relay20state = "on";// state of relay20
              relay21state = "on";// state of relay21
              relay22state = "on";// state of relay22
              relay23state = "on";// state of relay23
              relay24state = "on";// state of relay24

              relay25state = "on";// state of relay25
              relay26state = "on";// state of relay26
              relay27state = "on";// state of relay27
              relay28state = "on";// state of relay28
              relay29state = "on";// state of relay29
              relay30state = "on";// state of relay30
              relay31state = "on";// state of relay31
              relay32state = "on";// state of relay32*/

              pcf8574_R1.digitalWrite(P0, LOW);
              pcf8574_R1.digitalWrite(P1, LOW);
              pcf8574_R1.digitalWrite(P2, LOW);
              pcf8574_R1.digitalWrite(P3, LOW);
              pcf8574_R1.digitalWrite(P4, LOW);
              pcf8574_R1.digitalWrite(P5, LOW);
              pcf8574_R1.digitalWrite(P6, LOW);
              pcf8574_R1.digitalWrite(P7, LOW);

              pcf8574_R2.digitalWrite(P0, LOW);
              pcf8574_R2.digitalWrite(P1, LOW);
              pcf8574_R2.digitalWrite(P2, LOW);
              pcf8574_R2.digitalWrite(P3, LOW);
              pcf8574_R2.digitalWrite(P4, LOW);
              pcf8574_R2.digitalWrite(P5, LOW);
              pcf8574_R2.digitalWrite(P6, LOW);
              pcf8574_R2.digitalWrite(P7, LOW);
 /*
              pcf8574_R3.digitalWrite(P0, LOW);
              pcf8574_R3.digitalWrite(P1, LOW);
              pcf8574_R3.digitalWrite(P2, LOW);
              pcf8574_R3.digitalWrite(P3, LOW);
              pcf8574_R3.digitalWrite(P4, LOW);
              pcf8574_R3.digitalWrite(P5, LOW);
              pcf8574_R3.digitalWrite(P6, LOW);
              pcf8574_R3.digitalWrite(P7, LOW);

              pcf8574_R4.digitalWrite(P0, LOW);
              pcf8574_R4.digitalWrite(P1, LOW);
              pcf8574_R4.digitalWrite(P2, LOW);
              pcf8574_R4.digitalWrite(P3, LOW);
              pcf8574_R4.digitalWrite(P4, LOW);
              pcf8574_R4.digitalWrite(P5, LOW);
              pcf8574_R4.digitalWrite(P6, LOW);
              pcf8574_R4.digitalWrite(P7, LOW);*/

              
            }
            else if (header.indexOf("GET /all/off") >= 0)
            {
              relay1state = "off";// state of relay1
              relay2state = "off";// state of relay2
              relay3state = "off";// state of relay3
              relay4state = "off";// state of relay4
              relay5state = "off";// state of relay5
              relay6state = "off";// state of relay6
              relay7state = "off";// state of relay7
              relay8state = "off";// state of relay8

              relay9state = "off";// state of relay9
              relay10state = "off";// state of relay10
              relay11state = "off";// state of relay11
              relay12state = "off";// state of relay12
              relay13state = "off";// state of relay13
              relay14state = "off";// state of relay14
              relay15state = "off";// state of relay15
              relay16state = "off";// state of relay16
/*
              relay17state = "off";// state of relay17
              relay18state = "off";// state of relay18
              relay19state = "off";// state of relay19
              relay20state = "off";// state of relay20
              relay21state = "off";// state of relay21
              relay22state = "off";// state of relay22
              relay23state = "off";// state of relay23
              relay24state = "off";// state of relay24

              relay25state = "off";// state of relay25
              relay26state = "off";// state of relay26
              relay27state = "off";// state of relay27
              relay28state = "off";// state of relay28
              relay29state = "off";// state of relay29
              relay30state = "off";// state of relay30
              relay31state = "off";// state of relay31
              relay32state = "off";// state of relay32*/

              pcf8574_R1.digitalWrite(P0, HIGH);
              pcf8574_R1.digitalWrite(P1, HIGH);
              pcf8574_R1.digitalWrite(P2, HIGH);
              pcf8574_R1.digitalWrite(P3, HIGH);
              pcf8574_R1.digitalWrite(P4, HIGH);
              pcf8574_R1.digitalWrite(P5, HIGH);
              pcf8574_R1.digitalWrite(P6, HIGH);
              pcf8574_R1.digitalWrite(P7, HIGH);

              pcf8574_R2.digitalWrite(P0, HIGH);
              pcf8574_R2.digitalWrite(P1, HIGH);
              pcf8574_R2.digitalWrite(P2, HIGH);
              pcf8574_R2.digitalWrite(P3, HIGH);
              pcf8574_R2.digitalWrite(P4, HIGH);
              pcf8574_R2.digitalWrite(P5, HIGH);
              pcf8574_R2.digitalWrite(P6, HIGH);
              pcf8574_R2.digitalWrite(P7, HIGH);
 /*
              pcf8574_R3.digitalWrite(P0, HIGH);
              pcf8574_R3.digitalWrite(P1, HIGH);
              pcf8574_R3.digitalWrite(P2, HIGH);
              pcf8574_R3.digitalWrite(P3, HIGH);
              pcf8574_R3.digitalWrite(P4, HIGH);
              pcf8574_R3.digitalWrite(P5, HIGH);
              pcf8574_R3.digitalWrite(P6, HIGH);
              pcf8574_R3.digitalWrite(P7, HIGH);

              pcf8574_R4.digitalWrite(P0, HIGH);
              pcf8574_R4.digitalWrite(P1, HIGH);
              pcf8574_R4.digitalWrite(P2, HIGH);
              pcf8574_R4.digitalWrite(P3, HIGH);
              pcf8574_R4.digitalWrite(P4, HIGH);
              pcf8574_R4.digitalWrite(P5, HIGH);
              pcf8574_R4.digitalWrite(P6, HIGH);
              pcf8574_R4.digitalWrite(P7, HIGH);   */                    
            }          
          
          
          
          client.print("<!DOCTYPE HTML>\r\n");
          client.print("<html>\r\n");

            client.println("<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            client.println("<link rel=\"icon\" href=\"data:,\">");
            // CSS to style the on/off buttons 
            // Feel free to change the background-color and font-size attributes to fit your preferences
            client.println("<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}");
            client.println(".button { background-color: #195B6A; border: none; color: white; padding: 16px 40px;");
            client.println("text-decoration: none; font-size: 30px; margin: 2px; cursor: pointer;}");
            client.println(".button2 {background-color: #77878A;}</style></head>");
            
            if (flag_read_di==1)
            {
              client.println(" relay1:" + relay1state + " relay2:" + relay2state + " relay3:" + relay3state + " relay4:" + relay4state + " relay5:" + relay5state + " relay6:" + relay6state + " relay7:" + relay7state + " relay8:" + relay8state + " relay9:" + relay9state + " relay10:" + relay10state + " relay11:" + relay11state + " relay12:" + relay12state + " relay13:" + relay13state + " relay14:" + relay14state + " relay15:" + relay15state + " relay16:" + relay16state );
            }
            else
            {
            // Web Page Heading
            client.println("<body><h1>KC868-A16 Ethernet Web Server</h1>");


            // Display current state, and ON/OFF buttons for relay
            //client.println("<p>relay1 - State " + relay1state + "</p>");
            // If the relay is off, it displays the ON button      
            if (relay1state == "off") client.println("<a href=\"/1/on\"><button class=\"button\">1-ON</button></a>"); else client.println("<a href=\"/1/off\"><button class=\"button\">1-OFF</button></a>");
            if (relay2state == "off") client.println("<a href=\"/2/on\"><button class=\"button\">2-ON</button></a>"); else client.println("<a href=\"/2/off\"><button class=\"button\">2-OFF</button></a>");                                 
            if (relay3state == "off") client.println("<a href=\"/3/on\"><button class=\"button\">3-ON</button></a>"); else client.println("<a href=\"/3/off\"><button class=\"button\">3-OFF</button></a>");
            if (relay4state == "off") client.println("<a href=\"/4/on\"><button class=\"button\">4-ON</button></a>"); else client.println("<a href=\"/4/off\"><button class=\"button\">4-OFF</button></a>");
            if (relay5state == "off") client.println("<a href=\"/5/on\"><button class=\"button\">5-ON</button></a>"); else client.println("<a href=\"/5/off\"><button class=\"button\">5-OFF</button></a>");
            if (relay6state == "off") client.println("<a href=\"/6/on\"><button class=\"button\">6-ON</button></a>"); else client.println("<a href=\"/6/off\"><button class=\"button\">6-OFF</button></a>");                                 
            if (relay7state == "off") client.println("<a href=\"/7/on\"><button class=\"button\">7-ON</button></a>"); else client.println("<a href=\"/7/off\"><button class=\"button\">7-OFF</button></a>");
            if (relay8state == "off") client.println("<a href=\"/8/on\"><button class=\"button\">8-ON</button></a>"); else client.println("<a href=\"/8/off\"><button class=\"button\">8-OFF</button></a>");
            if (relay9state == "off") client.println("<a href=\"/9/on\"><button class=\"button\">9-ON</button></a>"); else client.println("<a href=\"/9/off\"><button class=\"button\">9-OFF</button></a>");
            if (relay10state == "off") client.println("<a href=\"/10/on\"><button class=\"button\">10-ON</button></a>"); else client.println("<a href=\"/10/off\"><button class=\"button\">10-OFF</button></a>");                                 
            if (relay11state == "off") client.println("<a href=\"/11/on\"><button class=\"button\">11-ON</button></a>"); else client.println("<a href=\"/11/off\"><button class=\"button\">11-OFF</button></a>");
            if (relay12state == "off") client.println("<a href=\"/12/on\"><button class=\"button\">12-ON</button></a>"); else client.println("<a href=\"/12/off\"><button class=\"button\">12-OFF</button></a>");
            if (relay13state == "off") client.println("<a href=\"/13/on\"><button class=\"button\">13-ON</button></a>"); else client.println("<a href=\"/13/off\"><button class=\"button\">13-OFF</button></a>");
            if (relay14state == "off") client.println("<a href=\"/14/on\"><button class=\"button\">14-ON</button></a>"); else client.println("<a href=\"/14/off\"><button class=\"button\">14-OFF</button></a>");                                 
            if (relay15state == "off") client.println("<a href=\"/15/on\"><button class=\"button\">15-ON</button></a>"); else client.println("<a href=\"/15/off\"><button class=\"button\">15-OFF</button></a>");
            if (relay16state == "off") client.println("<a href=\"/16/on\"><button class=\"button\">16-ON</button></a>"); else client.println("<a href=\"/16/off\"><button class=\"button\">16-OFF</button></a>");
        /*    if (relay17state == "off") client.println("<a href=\"/17/on\"><button class=\"button\">17-ON</button></a>"); else client.println("<a href=\"/17/off\"><button class=\"button\">17-OFF</button></a>");
            if (relay18state == "off") client.println("<a href=\"/18/on\"><button class=\"button\">18-ON</button></a>"); else client.println("<a href=\"/18/off\"><button class=\"button\">18-OFF</button></a>");                                 
            if (relay19state == "off") client.println("<a href=\"/19/on\"><button class=\"button\">19-ON</button></a>"); else client.println("<a href=\"/19/off\"><button class=\"button\">19-OFF</button></a>");
            if (relay20state == "off") client.println("<a href=\"/20/on\"><button class=\"button\">20-ON</button></a>"); else client.println("<a href=\"/20/off\"><button class=\"button\">20-OFF</button></a>");
            if (relay21state == "off") client.println("<a href=\"/21/on\"><button class=\"button\">21-ON</button></a>"); else client.println("<a href=\"/21/off\"><button class=\"button\">21-OFF</button></a>");
            if (relay22state == "off") client.println("<a href=\"/22/on\"><button class=\"button\">22-ON</button></a>"); else client.println("<a href=\"/22/off\"><button class=\"button\">22-OFF</button></a>");                                 
            if (relay23state == "off") client.println("<a href=\"/23/on\"><button class=\"button\">23-ON</button></a>"); else client.println("<a href=\"/23/off\"><button class=\"button\">23-OFF</button></a>");
            if (relay24state == "off") client.println("<a href=\"/24/on\"><button class=\"button\">24-ON</button></a>"); else client.println("<a href=\"/24/off\"><button class=\"button\">24-OFF</button></a>");
            if (relay25state == "off") client.println("<a href=\"/25/on\"><button class=\"button\">25-ON</button></a>"); else client.println("<a href=\"/25/off\"><button class=\"button\">25-OFF</button></a>");
            if (relay26state == "off") client.println("<a href=\"/26/on\"><button class=\"button\">26-ON</button></a>"); else client.println("<a href=\"/26/off\"><button class=\"button\">26-OFF</button></a>");                                 
            if (relay27state == "off") client.println("<a href=\"/27/on\"><button class=\"button\">27-ON</button></a>"); else client.println("<a href=\"/27/off\"><button class=\"button\">27-OFF</button></a>");
            if (relay28state == "off") client.println("<a href=\"/28/on\"><button class=\"button\">28-ON</button></a>"); else client.println("<a href=\"/28/off\"><button class=\"button\">28-OFF</button></a>");
            if (relay29state == "off") client.println("<a href=\"/29/on\"><button class=\"button\">29-ON</button></a>"); else client.println("<a href=\"/29/off\"><button class=\"button\">29-OFF</button></a>");
            if (relay30state == "off") client.println("<a href=\"/30/on\"><button class=\"button\">30-ON</button></a>"); else client.println("<a href=\"/30/off\"><button class=\"button\">30-OFF</button></a>");                                 
            if (relay31state == "off") client.println("<a href=\"/31/on\"><button class=\"button\">31-ON</button></a>"); else client.println("<a href=\"/31/off\"><button class=\"button\">31-OFF</button></a>");
            if (relay32state == "off") client.println("<a href=\"/32/on\"><button class=\"button\">32-ON</button></a>"); else client.println("<a href=\"/32/off\"><button class=\"button\">32-OFF</button></a>");
*/

              client.println("<a href=\"/all/on\"><button class=\"button\">all ON</button></a>");
              client.println("<a href=\"/all/off\"><button class=\"button\">all OFF</button></a>");
            }  
            client.println("</body></html>");
            
            // The HTTP response ends with another blank line
            client.println();
            // Break out of the while loop
            break;
          } else { // if you got a newline, then clear currentLine
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }
      }
    }
    // Clear the header variable
    header = "";
    // Close the connection
    client.stop();
    Serial.println("Client disconnected.");
    Serial.println("");
    flag_read_di=0;
  }

  ScanKey();            //scan key
}

void ScanKey()            
{
                    
  if(pcf8574_I1.digitalRead(P0) == LOW)         //key1 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I1.digitalRead(P0) == LOW)       //key1 pressed again
    {
      pcf8574_R1.digitalWrite(P0,!pcf8574_R1.digitalRead(P0));    // toggle relay1 state     
      while(pcf8574_I1.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574_R1.digitalRead(P0) == LOW) relay1state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I1.digitalRead(P1) == LOW)         //key2 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I1.digitalRead(P1) == LOW)       //key2 pressed again
    {
      pcf8574_R1.digitalWrite(P1,!pcf8574_R1.digitalRead(P1));    // toggle relay2 state     
      while(pcf8574_I1.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574_R1.digitalRead(P1) == LOW) relay2state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I1.digitalRead(P2) == LOW)         //key3 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I1.digitalRead(P2) == LOW)       //key3 pressed again
    {
      pcf8574_R1.digitalWrite(P2,!pcf8574_R1.digitalRead(P2));    // toggle relay3 state     
      while(pcf8574_I1.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574_R1.digitalRead(P2) == LOW) relay3state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I1.digitalRead(P3) == LOW)         //key4 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I1.digitalRead(P3) == LOW)       //key4 pressed again
    {
      pcf8574_R1.digitalWrite(P3,!pcf8574_R1.digitalRead(P3));    // toggle relay4 state     
      while(pcf8574_I1.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574_R1.digitalRead(P3) == LOW) relay4state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I1.digitalRead(P4) == LOW)         //key5 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I1.digitalRead(P4) == LOW)       //key5 pressed again
    {
      pcf8574_R1.digitalWrite(P4,!pcf8574_R1.digitalRead(P4));    // toggle relay5 state     
      while(pcf8574_I1.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574_R1.digitalRead(P4) == LOW) relay5state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I1.digitalRead(P5) == LOW)         //key6 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I1.digitalRead(P5) == LOW)       //key6 pressed again
    {
      pcf8574_R1.digitalWrite(P5,!pcf8574_R1.digitalRead(P5));    // toggle relay6 state     
      while(pcf8574_I1.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574_R1.digitalRead(P5) == LOW) relay6state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I1.digitalRead(P6) == LOW)         //key7 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I1.digitalRead(P6) == LOW)       //key7 pressed again
    {
      pcf8574_R1.digitalWrite(P6,!pcf8574_R1.digitalRead(P6));    // toggle relay7 state     
      while(pcf8574_I1.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574_R1.digitalRead(P6) == LOW) relay7state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I1.digitalRead(P7) == LOW)         //key8 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I1.digitalRead(P7) == LOW)       //key8 pressed again
    {
      pcf8574_R1.digitalWrite(P7,!pcf8574_R1.digitalRead(P7));    // toggle relay8 state     
      while(pcf8574_I1.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574_R1.digitalRead(P7) == LOW) relay8state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I2.digitalRead(P0) == LOW)         //key9 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I2.digitalRead(P0) == LOW)       //key9 pressed again
    {
      pcf8574_R2.digitalWrite(P0,!pcf8574_R2.digitalRead(P0));    // toggle relay9 state     
      while(pcf8574_I2.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574_R2.digitalRead(P0) == LOW) relay9state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I2.digitalRead(P1) == LOW)         //key10 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I2.digitalRead(P1) == LOW)       //key10 pressed again
    {
      pcf8574_R2.digitalWrite(P1,!pcf8574_R2.digitalRead(P1));    // toggle relay10 state     
      while(pcf8574_I2.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574_R2.digitalRead(P1) == LOW) relay10state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I2.digitalRead(P2) == LOW)         //key11 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I2.digitalRead(P2) == LOW)       //key11 pressed again
    {
      pcf8574_R2.digitalWrite(P2,!pcf8574_R2.digitalRead(P2));    // toggle relay11 state     
      while(pcf8574_I2.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574_R2.digitalRead(P2) == LOW) relay11state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I2.digitalRead(P3) == LOW)         //key12 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I2.digitalRead(P3) == LOW)       //key12 pressed again
    {
      pcf8574_R2.digitalWrite(P3,!pcf8574_R2.digitalRead(P3));    // toggle relay12 state     
      while(pcf8574_I2.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574_R2.digitalRead(P3) == LOW) relay12state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I2.digitalRead(P4) == LOW)         //key13 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I2.digitalRead(P4) == LOW)       //key13 pressed again
    {
      pcf8574_R2.digitalWrite(P4,!pcf8574_R2.digitalRead(P4));    // toggle relay13 state     
      while(pcf8574_I2.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574_R2.digitalRead(P4) == LOW) relay13state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I2.digitalRead(P5) == LOW)         //key14 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I2.digitalRead(P5) == LOW)       //key14 pressed again
    {
      pcf8574_R2.digitalWrite(P5,!pcf8574_R2.digitalRead(P5));    // toggle relay14 state     
      while(pcf8574_I2.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574_R2.digitalRead(P5) == LOW) relay14state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I2.digitalRead(P6) == LOW)         //key15 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I2.digitalRead(P6) == LOW)       //key15 pressed again
    {
      pcf8574_R2.digitalWrite(P6,!pcf8574_R2.digitalRead(P6));    // toggle relay15 state     
      while(pcf8574_I2.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574_R2.digitalRead(P6) == LOW) relay15state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I2.digitalRead(P7) == LOW)         //key16 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I2.digitalRead(P7) == LOW)       //key16 pressed again
    {
      pcf8574_R2.digitalWrite(P7,!pcf8574_R2.digitalRead(P7));    // toggle relay16 state     
      while(pcf8574_I2.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574_R2.digitalRead(P7) == LOW) relay16state= "on"; else relay1state= "off";
    }
  }

/*
  if(pcf8574_I3.digitalRead(P0) == LOW)         //key17 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I3.digitalRead(P0) == LOW)       //key17 pressed again
    {
      pcf8574_R3.digitalWrite(P0,!pcf8574_R3.digitalRead(P0));    // toggle relay17 state     
      while(pcf8574_I3.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574_R3.digitalRead(P0) == LOW) relay17state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I3.digitalRead(P1) == LOW)         //key18 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I3.digitalRead(P1) == LOW)       //key18 pressed again
    {
      pcf8574_R3.digitalWrite(P1,!pcf8574_R3.digitalRead(P1));    // toggle relay18 state     
      while(pcf8574_I3.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574_R3.digitalRead(P1) == LOW) relay18state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I3.digitalRead(P2) == LOW)         //key19 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I3.digitalRead(P2) == LOW)       //key19 pressed again
    {
      pcf8574_R3.digitalWrite(P2,!pcf8574_R3.digitalRead(P2));    // toggle relay19 state     
      while(pcf8574_I3.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574_R3.digitalRead(P2) == LOW) relay19state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I3.digitalRead(P3) == LOW)         //key20 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I3.digitalRead(P3) == LOW)       //key20 pressed again
    {
      pcf8574_R3.digitalWrite(P3,!pcf8574_R3.digitalRead(P3));    // toggle relay20 state     
      while(pcf8574_I3.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574_R3.digitalRead(P3) == LOW) relay20state= "on"; else relay1state= "off";
    }
  }

  if(pcf8574_I3.digitalRead(P4) == LOW)         //key21 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I3.digitalRead(P4) == LOW)       //key21 pressed again
    {
      pcf8574_R3.digitalWrite(P4,!pcf8574_R3.digitalRead(P4));    // toggle relay21 state     
      while(pcf8574_I3.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574_R3.digitalRead(P4) == LOW) relay21state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I3.digitalRead(P5) == LOW)         //key22 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I3.digitalRead(P5) == LOW)       //key22 pressed again
    {
      pcf8574_R3.digitalWrite(P5,!pcf8574_R3.digitalRead(P5));    // toggle relay22 state     
      while(pcf8574_I3.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574_R3.digitalRead(P5) == LOW) relay22state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I3.digitalRead(P6) == LOW)         //key23 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I3.digitalRead(P6) == LOW)       //key23 pressed again
    {
      pcf8574_R3.digitalWrite(P6,!pcf8574_R3.digitalRead(P6));    // toggle relay23 state     
      while(pcf8574_I3.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574_R3.digitalRead(P6) == LOW) relay23state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I3.digitalRead(P7) == LOW)         //key24 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I3.digitalRead(P7) == LOW)       //key24 pressed again
    {
      pcf8574_R3.digitalWrite(P7,!pcf8574_R3.digitalRead(P7));    // toggle relay24 state     
      while(pcf8574_I3.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574_R3.digitalRead(P7) == LOW) relay24state= "on"; else relay1state= "off";
    }
  }

  if(pcf8574_I4.digitalRead(P0) == LOW)         //key25 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I4.digitalRead(P0) == LOW)       //key25 pressed again
    {
      pcf8574_R4.digitalWrite(P0,!pcf8574_R4.digitalRead(P0));    // toggle relay25 state     
      while(pcf8574_I4.digitalRead(P0) == LOW); //wait remove hand
      if (pcf8574_R4.digitalRead(P0) == LOW) relay25state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I4.digitalRead(P1) == LOW)         //key26 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I4.digitalRead(P1) == LOW)       //key26 pressed again
    {
      pcf8574_R4.digitalWrite(P1,!pcf8574_R4.digitalRead(P1));    // toggle relay26 state     
      while(pcf8574_I4.digitalRead(P1) == LOW); //wait remove hand
      if (pcf8574_R4.digitalRead(P1) == LOW) relay26state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I4.digitalRead(P2) == LOW)         //key27 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I4.digitalRead(P2) == LOW)       //key27 pressed again
    {
      pcf8574_R4.digitalWrite(P2,!pcf8574_R4.digitalRead(P2));    // toggle relay27 state     
      while(pcf8574_I4.digitalRead(P2) == LOW); //wait remove hand
      if (pcf8574_R4.digitalRead(P2) == LOW) relay27state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I4.digitalRead(P3) == LOW)         //key28 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I4.digitalRead(P3) == LOW)       //key28 pressed again
    {
      pcf8574_R4.digitalWrite(P3,!pcf8574_R4.digitalRead(P3));    // toggle relay28 state     
      while(pcf8574_I4.digitalRead(P3) == LOW); //wait remove hand
      if (pcf8574_R4.digitalRead(P3) == LOW) relay28state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I4.digitalRead(P4) == LOW)         //key29 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I4.digitalRead(P4) == LOW)       //key29 pressed again
    {
      pcf8574_R4.digitalWrite(P4,!pcf8574_R4.digitalRead(P4));    // toggle relay29 state     
      while(pcf8574_I4.digitalRead(P4) == LOW); //wait remove hand
      if (pcf8574_R4.digitalRead(P4) == LOW) relay29state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I4.digitalRead(P5) == LOW)         //key30 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I4.digitalRead(P5) == LOW)       //key30 pressed again
    {
      pcf8574_R4.digitalWrite(P5,!pcf8574_R4.digitalRead(P5));    // toggle relay30 state     
      while(pcf8574_I4.digitalRead(P5) == LOW); //wait remove hand
      if (pcf8574_R4.digitalRead(P5) == LOW) relay30state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I4.digitalRead(P6) == LOW)         //key31 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I4.digitalRead(P6) == LOW)       //key31 pressed again
    {
      pcf8574_R4.digitalWrite(P6,!pcf8574_R4.digitalRead(P6));    // toggle relay31 state     
      while(pcf8574_I4.digitalRead(P6) == LOW); //wait remove hand
      if (pcf8574_R4.digitalRead(P6) == LOW) relay31state= "on"; else relay1state= "off";
    }
  }


  if(pcf8574_I4.digitalRead(P7) == LOW)         //key32 pressed
  {
    delay(20);                        //anti-interference
    if(pcf8574_I4.digitalRead(P7) == LOW)       //key32 pressed again
    {
      pcf8574_R4.digitalWrite(P7,!pcf8574_R4.digitalRead(P7));    // toggle relay32 state     
      while(pcf8574_I4.digitalRead(P7) == LOW); //wait remove hand
      if (pcf8574_R4.digitalRead(P7) == LOW) relay32state= "on"; else relay1state= "off";
    }
  }
*/

}
