/*
-----------------------------------------------
|  NodeMCU32s            |   SD Card          |
|  --------------------------------------------
|  -                     |   D02              |
|  -                     |   D01              |
|  GPIO23                |   CMD(MOSI)        |
|  GPIO19                |   D00(MISO)        |
|  GPIO18                |   CLK(SCK)         |
|  GPIO5                 |   D03(SS)          |
|  GND                   |   GND              |
|  VCC(3.3v)             |   VCC              |
-----------------------------------------------
*/
#include "FS.h"
#include "SD.h"
#include "SD_MMC.h"

void WriteFile(fs::FS &fs, const char *path, uint8_t *buf, int len)
{
  //unsigned long start_time = millis();
  Serial.printf("write [%s]...\n", path);

  File file = fs.open(path, FILE_WRITE);
  if (!file) {
    Serial.println("Failed to open file for writing");
    return;
  }
  
  if (!file.write(buf, len)) {
      Serial.println("Write failed");
      return;
    }

  file.flush();
  file.close();

  Serial.printf("Write [%s] Complete", path);
}

void ReadFile(fs::FS &fs, const char *path, uint8_t *buf, int len)
{
  Serial.printf("read [%s]...\n", path);

  File file = fs.open(path);
  if (!file) {
    Serial.println("Failed to open file for reading");
    return;
  }

  if (!file.read(buf, len)) {
      Serial.println("Read failed");
      return;
  }
  
  file.close();

  Serial.printf("Read [%s] Complete: %s", path, buf);
}

void testIO(fs::FS &fs)
{
  char buf[] = "hello world";

  WriteFile(fs, "/test.txt", (uint8_t *)buf, strlen(buf));
  ReadFile(fs, "/test.txt", (uint8_t *)buf, strlen(buf));
}

void setup() {
  // put your setup code here, to run once:
  Serial.begin(115200);

  Serial.println("please insert SD card");
  delay(8000);

  /* SD SPI Mode at VSPI */
  SPIClass spi = SPIClass(HSPI);
  spi.begin(18 /* SCK */, 19 /* MISO */, 23 /* MOSI */, 5 /* SS */);
  if (!SD.begin(5 /* SS */, spi, 80000000)) {
    Serial.println("Card Mount Failed");
    return;
  }
  testIO(SD);
  SD_MMC.end(); // cancel load SD card
}
void loop() {
}
