#include <PCA95x5.h>

PCA9555 ioex;

void setup() {
    Serial.begin(115200);
    delay(100);

    Wire.begin(11,10,100000);
    ioex.attach(Wire,0x21);
    ioex.polarity(PCA95x5::Polarity::ORIGINAL_ALL);
    ioex.direction(PCA95x5::Direction::OUT_ALL);
    ioex.write(PCA95x5::Level::H_ALL);
    delay(2000);
}

void loop() {
    for (size_t i = 0; i < 16; ++i) {
        Serial.print("set port low: ");  //turn ON relay
        Serial.println(i);

        ioex.write((PCA95x5::Port::Port)i, PCA95x5::Level::L);
        Serial.println(ioex.read(), BIN);
        delay(500);
    }

    for (size_t i = 0; i < 16; ++i) {
        Serial.print("set port high: "); //turn OFF relay
        Serial.println(i);

        ioex.write((PCA95x5::Port::Port)i, PCA95x5::Level::H);
        Serial.println(ioex.read(), BIN);
        delay(500);
    }
}
