#include <DS3231.h>
#include <Wire.h>

String serial_cmd_rcv = ""; //串口接收数据

typedef struct
{
  byte year;// Last two digits of the year, lib will add 2000.
  byte month;
  byte day;
  byte hour ;
  byte minute ;
  byte second ;
}MY_DATE_STR;

MY_DATE_STR my_date_str = {0};

#define OPEN_RLY_DATA   26
#define OPEN_RLY_MONTH  4

#define CLOSE_RLY_DATA   2
#define CLOSE_RLY_MONTH   5

#define SDA_PIN   26
#define SCL_PIN   27

#define RLY1_PIN  19
#define RLY2_PIN  5

DS3231  rtc; 
bool h12Flag;
bool pmFlag;
static bool bCentury = false;
static bool old_level_high = false;
static bool old_level_low = false;

static bool CompareOpenDate()
{
  return (rtc.getDate()==OPEN_RLY_DATA)&(rtc.getMonth(bCentury)==OPEN_RLY_MONTH);
}

static bool CompareCloseDate()
{
  return (rtc.getDate()==CLOSE_RLY_DATA)&(rtc.getMonth(bCentury)==CLOSE_RLY_MONTH);
}

static void PrintfCurTime()
{
  Serial.print("current time is: ");
  int year = rtc.getYear() + 2000;
  Serial.print(year);
  Serial.print("-");
  
  Serial.print(rtc.getMonth(bCentury), DEC);
  Serial.print("-");
  
  // then the date
  Serial.print(rtc.getDate(), DEC);
  Serial.print(" ");
  
  // and the day of the week
  //Serial.print(rtc.getDoW(), DEC);
  //Serial.print(" ");
  
  // Finally the hour, minute, and second
  Serial.print(rtc.getHour(h12Flag, pmFlag), DEC);
  Serial.print(":");
  Serial.print(rtc.getMinute(), DEC);
  Serial.print(":");
  Serial.println(rtc.getSecond(), DEC);
  
}
static void GetSerialCmd() 
{ ////format:D2024-04-28T11:50:22
 
  /*while (Serial.available() > 0)
  {
    serial_cmd_rcv += char(Serial.read());
    delay(5);  
  } */
  if(Serial.available() > 0)
  {
    delay(100);
    int num_read = Serial.available();
    while(num_read--)
      serial_cmd_rcv += char(Serial.read());
  }
  else return;
   
  serial_cmd_rcv.trim();

  if(serial_cmd_rcv == "current time")
  {
    PrintfCurTime();
    serial_cmd_rcv = "";
    return;
  }

  Serial.print("rcv length:");
  Serial.println(serial_cmd_rcv.length());

  int indexof_d = serial_cmd_rcv.indexOf('D');
  int indexof_t = serial_cmd_rcv.indexOf('T');

  Serial.print("d index:");Serial.print(indexof_d);
  Serial.print(" t index:");Serial.println(indexof_t);
  
  if (serial_cmd_rcv.length() != 20 || 
      serial_cmd_rcv.substring(0,1) != "D" ||
      serial_cmd_rcv.substring(11,12) != "T")  
  {
    
    Serial.println(serial_cmd_rcv);
    serial_cmd_rcv="";
    return;
    }
    
  Serial.println("setting is start!");
  
  my_date_str.year = (byte)serial_cmd_rcv.substring(3,5).toInt();
  my_date_str.month = (byte)serial_cmd_rcv.substring(6,8).toInt();
  my_date_str.day = (byte)serial_cmd_rcv.substring(9,11).toInt();

  my_date_str.hour = (byte)serial_cmd_rcv.substring(12,14).toInt();
  my_date_str.minute = (byte)serial_cmd_rcv.substring(15,17).toInt();
  my_date_str.second = (byte)serial_cmd_rcv.substring(18).toInt();

  rtc.setYear(my_date_str.year);
  rtc.setMonth(my_date_str.month);
  rtc.setDate(my_date_str.day);
  rtc.setHour(my_date_str.hour);
  rtc.setMinute(my_date_str.minute);
  rtc.setSecond(my_date_str.second);
  
  serial_cmd_rcv = ""; 

  Serial.println("setting is ending!");
}

static bool GetEdgeP(bool cur,bool old)  {return (cur & !old);}
static bool bOpen,bClose;

void setup() {
  // put your setup code here, to run once:
  // Start the I2C interface
  Wire.begin(SDA_PIN,SCL_PIN,40000);
  
  // Setup Serial connection
  Serial.begin(115200);
  
  pinMode(RLY1_PIN,OUTPUT);
  pinMode(RLY2_PIN,OUTPUT);
  
  // Set 12/24h mode. True is 12-h, false is 24-hour.
  rtc.setClockMode(false);////24h

  PrintfCurTime();

  while(Serial.read()>=0){}
 
}

void loop() {
  // put your main code here, to run repeatedly:
   
  GetSerialCmd();
  
  bOpen = CompareOpenDate();
  bClose = CompareCloseDate();
  if(GetEdgeP(bOpen,old_level_high)) digitalWrite(RLY1_PIN,HIGH);
  if(GetEdgeP(bClose,old_level_low)) digitalWrite(RLY1_PIN,LOW);


  old_level_high = bOpen;
  old_level_low = bClose;
  //delay (1000);
  
}
