/*
 * Made by KinCony IoT: https://www.kincony.com
 *
 * This Arduino program controls the GP8403 DAC I2C chip using an ESP32-S3 board. 
 * The program sets the DAC outputs for two channels:
 * - Channel 0 (CH0) outputs 5V.
 * - Channel 1 (CH1) outputs 10V.
 *
 * The I2C communication is handled using the Wire library, and the SDA and SCL pins 
 * are custom defined as GPIO11 (SDA) and GPIO10 (SCL).
 *
 * GP8403 I2C address: 0x58
 */

#include "DFRobot_GP8403.h"

// Initialize the GP8403 DAC object with the I2C address 0x58
DFRobot_GP8403 dac(&Wire, 0x58);

void setup() {
  // Start serial communication for debugging purposes
  Serial.begin(115200);

  // Initialize I2C communication with custom SDA and SCL pins
  Wire.begin(11, 10);  // SDA = GPIO11, SCL = GPIO10

  // Try to initialize the DAC, retry if initialization fails
  while(dac.begin() != 0) {
    Serial.println("Initialization failed, retrying...");
    delay(1000);  // Wait for 1 second before retrying
  }

  // If initialization succeeds
  Serial.println("Initialization successful!");

  // Set the DAC output range to 10V (this setting applies to both channels)
  dac.setDACOutRange(dac.eOutputRange10V);

  // Set the output for DAC channel 0 to 5V
  // Range for 10V mode is 0-10000, so 5000 represents 5V
  dac.setDACOutVoltage(5000, 0);  // Set CH0 to 5V
  Serial.println("Channel 0 set to 5V");

  // Set the output for DAC channel 1 to 10V
  dac.setDACOutVoltage(10000, 1);  // Set CH1 to 10V
  Serial.println("Channel 1 set to 10V");

  // Store the data in the chip's non-volatile memory so it persists after power-off
  dac.store();
  Serial.println("DAC values stored in memory");
}

void loop() {
  // No need to continuously write the values, the DAC holds the last set value
}
