/*

  HelloWorld.ino

  Universal 8bit Graphics Library (https://github.com/olikraus/u8g2/)

  Copyright (c) 2016, olikraus@gmail.com
  All rights reserved.

  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice, this list 
    of conditions and the following disclaimer.
    
  * Redistributions in binary form must reproduce the above copyright notice, this 
    list of conditions and the following disclaimer in the documentation and/or other 
    materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR 
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  

*/

#include <Arduino.h>
#include <U8g2lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif

#include "Arduino.h"
#include "PCF8574.h"

// Set i2c address
PCF8574 pcf8574(0x22,4,15);

String relaystate[16]={"relay1state","relay2state","relay3state","relay4state",
                       "relay5state","relay6state"
                      };
String relay1state = "off";// state of relay1
String relay2state = "off";// state of relay2
String relay3state = "off";// state of relay3
String relay4state = "off";// state of relay4
String relay5state = "off";// state of relay5
String relay6state = "off";// state of relay6
/*
  U8g2lib Example Overview:
    Frame Buffer Examples: clearBuffer/sendBuffer. Fast, but may not work with all Arduino boards because of RAM consumption
    Page Buffer Examples: firstPage/nextPage. Less RAM usage, should work with all Arduino boards.
    U8x8 Text Only Example: No RAM usage, direct communication with display controller. No graphics, 8x8 Text only.
    
*/
U8G2_SSD1306_128X64_NONAME_F_SW_I2C u8g2(U8G2_R0,  15, 4, U8X8_PIN_NONE);//SCL IO15  SDA  IO4

 
// End of constructor list


void setup(void) {
  u8g2.begin();

 Serial.begin(115200);
//    delay(1000);

  
    pcf8574.pinMode(P0, INPUT);
    pcf8574.pinMode(P1, INPUT);
    pcf8574.pinMode(P2, INPUT);
    pcf8574.pinMode(P3, INPUT);
    pcf8574.pinMode(P4, INPUT);
    pcf8574.pinMode(P5, INPUT);
    pcf8574.pinMode(P6, INPUT);
    pcf8574.pinMode(P7, INPUT);
    
        Serial.print("Init pcf8574...");
        if (pcf8574.begin()){
            Serial.println("OK");
        }else{
            Serial.println("KO");
        }
}

void loop(void) {
 

    uint8_t val1 = pcf8574.digitalRead(P0);
    uint8_t val2 = pcf8574.digitalRead(P1);
    uint8_t val3 = pcf8574.digitalRead(P2);
    uint8_t val4 = pcf8574.digitalRead(P3);
    uint8_t val5 = pcf8574.digitalRead(P4);
    uint8_t val6 = pcf8574.digitalRead(P5);
    uint8_t val7 = pcf8574.digitalRead(P6);
    uint8_t val8 = pcf8574.digitalRead(P7);
    if (val1==LOW) {
        Serial.println("KEY1 PRESSED");
        relay1state = "on";

           u8g2.clearBuffer();          // clear the internal memory
          u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
          u8g2.drawStr(3,30,"Teclado salida!");  // write something to the internal memory
          u8g2.sendBuffer();          // transfer internal memory to the display
          delay(1000);  

       
    }
    if (val2==LOW){ 
      Serial.println("KEY2 PRESSED");
         u8g2.clearBuffer();          // clear the internal memory
          u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
          u8g2.drawStr(3,50,"Teclado entrada!");  // write something to the internal memory
          u8g2.sendBuffer();          // transfer internal memory to the display
          delay(1000);  
    }
    
    if (val3==LOW) Serial.println("KEY3 PRESSED");
    if (val4==LOW) Serial.println("KEY4 PRESSED");
    if (val5==LOW) Serial.println("KEY5 PRESSED");
    if (val6==LOW) Serial.println("KEY6 PRESSED");
    if (val7==LOW) Serial.println("KEY7 PRESSED");
    if (val8==LOW) Serial.println("KEY8 PRESSED");
        delay(300);
}
