/*
  Made by KinCony IoT: https://www.kincony.com
  This code controls 3 WS2812 RGB LEDs connected to GPIO 15 on an ESP32-S3.
  Each LED will be set to blue with adjustable brightness.
  The Adafruit NeoPixel library is used to communicate with the WS2812 LEDs.

  Hardware setup:
  - WS2812 RGB LEDs are connected to GPIO 15 (data pin).
  - Total number of LEDs: 3.
*/

#include <Adafruit_NeoPixel.h>

// Create an instance of the Adafruit_NeoPixel class
// Parameters: number of LEDs (3), data pin (GPIO 15), LED type (NEO_GRB with 800 KHz communication)
Adafruit_NeoPixel rgb_display = Adafruit_NeoPixel(3, 15, NEO_GRB + NEO_KHZ800);

void setup() {
  // Initialize the NeoPixel library and prepare the LEDs for use
  rgb_display.begin();
}

void loop() {
  /*
    rgb_display.setPixelColor(uint16_t n, uint32_t c);
    This function sets the color of a specific LED.

    Parameters:
    - n: The LED number (starting from 0).
    - c: The color to set the LED to, in hexadecimal (0x0000ff = blue in RGB format).
  */

  // Set the first LED (LED 0) to blue
  rgb_display.setPixelColor(0, (0x0000ff)); // Blue color for the first LED (index 0)
  rgb_display.setBrightness(100);           // Set brightness to 100 out of 255
  rgb_display.show();                       // Update the LED to reflect the change

  // Set the second LED (LED 1) to blue
  rgb_display.setPixelColor(1, (0x0000ff)); // Blue color for the second LED (index 1)
  rgb_display.setBrightness(100);           // Set brightness to 100 out of 255
  rgb_display.show();                       // Update the LED to reflect the change

  // Set the third LED (LED 2) to blue
  rgb_display.setPixelColor(2, (0x0000ff)); // Blue color for the third LED (index 2)
  rgb_display.setBrightness(100);           // Set brightness to 100 out of 255
  rgb_display.show();                       // Update the LED to reflect the change
}

