/*
 * Made by KinCony IoT: https://www.kincony.com
 *
 * RS485 Communication Test with Echo
 *
 * This program tests RS485 communication using ESP32-S3.
 * It sends a message over RS485, reads incoming messages, and echoes them back.
 * The TXD pin is defined as GPIO 9 and RXD pin is defined as GPIO 8.
 */

#include <HardwareSerial.h>

// Define RS485 pins
#define RS485_RXD 18
#define RS485_TXD 17

// Create a hardware serial object
HardwareSerial rs485Serial(1);

void setup() {
  // Start serial communication for debugging
  Serial.begin(115200);
  while (!Serial);

  // Initialize RS485 Serial communication
  rs485Serial.begin(9600, SERIAL_8N1, RS485_RXD, RS485_TXD);
  
  Serial.println("RS485 Test Start");
}

void loop() {
  // Send a test message periodically
 // rs485Serial.println("Hello from KinCony A32 Pro!");

  // Wait for a short period
  delay(100);

  // Check if data is available to read from RS485
  if (rs485Serial.available()) {
    String receivedMessage = "";
    while (rs485Serial.available()) {
      char c = rs485Serial.read();
      receivedMessage += c;
    }
    
    // Print the received message to the serial monitor
    Serial.print("Received: ");
    Serial.println(receivedMessage);
    
    // Echo the received message back over RS485
    rs485Serial.print("Echo: ");
    rs485Serial.println(receivedMessage);
  }

  // Wait before sending the next message
  delay(2000);
}
