#include <Wire.h>        // I2C communication
#include <PCF8574.h>     // Library to control the PCF8575 I/O expander

// Define I2C pins
#define SDA 9           // SDA pin
#define SCL 10           // SCL pin
TwoWire I2Cone = TwoWire(0);

PCF8574 pcf8574_I1(&I2Cone, 0x21, SDA, SCL);
PCF8574 pcf8574_I2(&I2Cone, 0x22, SDA, SCL);

PCF8574 pcf8574_R1(&I2Cone, 0x24, SDA, SCL);
PCF8574 pcf8574_R2(&I2Cone, 0x25, SDA, SCL);

void setup() {
  
  // Initialize serial communication
  Serial.begin(115200);
  
  // Initialize input and relay modules
  // Set pinMode to OUTPUT
 pcf8574_R1.pinMode(P0, OUTPUT);
 pcf8574_R1.pinMode(P1, OUTPUT);
 pcf8574_R1.pinMode(P2, OUTPUT);
 pcf8574_R1.pinMode(P3, OUTPUT);
 pcf8574_R1.pinMode(P4, OUTPUT);
 pcf8574_R1.pinMode(P5, OUTPUT);
 pcf8574_R1.pinMode(P6, OUTPUT);
 pcf8574_R1.pinMode(P7, OUTPUT);

 pcf8574_R2.pinMode(P0, OUTPUT);
 pcf8574_R2.pinMode(P1, OUTPUT);
 pcf8574_R2.pinMode(P2, OUTPUT);
 pcf8574_R2.pinMode(P3, OUTPUT);
 pcf8574_R2.pinMode(P4, OUTPUT);
 pcf8574_R2.pinMode(P5, OUTPUT);
 pcf8574_R2.pinMode(P6, OUTPUT);
 pcf8574_R2.pinMode(P7, OUTPUT);

 pcf8574_I1.pinMode(P0, INPUT);
 pcf8574_I1.pinMode(P1, INPUT);
 pcf8574_I1.pinMode(P2, INPUT);
 pcf8574_I1.pinMode(P3, INPUT);
 pcf8574_I1.pinMode(P4, INPUT);
 pcf8574_I1.pinMode(P5, INPUT);
 pcf8574_I1.pinMode(P6, INPUT);
 pcf8574_I1.pinMode(P7, INPUT);

 pcf8574_I2.pinMode(P0, INPUT);
 pcf8574_I2.pinMode(P1, INPUT);
 pcf8574_I2.pinMode(P2, INPUT);
 pcf8574_I2.pinMode(P3, INPUT);
 pcf8574_I2.pinMode(P4, INPUT);
 pcf8574_I2.pinMode(P5, INPUT);
 pcf8574_I2.pinMode(P6, INPUT);
 pcf8574_I2.pinMode(P7, INPUT);

  Serial.print("Init pcf8574_R1...");
  if (pcf8574_R1.begin()){
    Serial.println("PCF8574_R1_OK");
  }else{
    Serial.println("PCF8574_R1_KO");
  }

  Serial.print("Init pcf8574_R2...");
  if (pcf8574_R2.begin()){
    Serial.println("PCF8574_R2_OK");
  }else{
    Serial.println("PCF8574_R2_KO");
  }

  Serial.print("Init pcf8574...");
  if (pcf8574_I1.begin()){
    Serial.println("pcf8574_I1_OK");
  }else{
    Serial.println("pcf8574_I1_KO");
  }

  Serial.print("Init pcf8574...");
  if (pcf8574_I2.begin()){
    Serial.println("pcf8574_I2_OK");
  }else{
    Serial.println("pcf8574_I2_KO");
  }

  pcf8574_R1.digitalWrite(P0, HIGH);
  pcf8574_R1.digitalWrite(P1, HIGH);
  pcf8574_R1.digitalWrite(P2, HIGH);
  pcf8574_R1.digitalWrite(P3, HIGH);
  pcf8574_R1.digitalWrite(P4, HIGH);
  pcf8574_R1.digitalWrite(P5, HIGH);
  pcf8574_R1.digitalWrite(P6, HIGH);
  pcf8574_R1.digitalWrite(P7, HIGH);
  

  pcf8574_R2.digitalWrite(P0, HIGH);
  pcf8574_R2.digitalWrite(P1, HIGH);
  pcf8574_R2.digitalWrite(P2, HIGH);
  pcf8574_R2.digitalWrite(P3, HIGH);
  pcf8574_R2.digitalWrite(P4, HIGH);
  pcf8574_R2.digitalWrite(P5, HIGH);
  pcf8574_R2.digitalWrite(P6, HIGH);
  pcf8574_R2.digitalWrite(P7, HIGH);

}

void loop() {
 uint8_t val1 = pcf8574_I1.digitalRead(P0);
 uint8_t val2 = pcf8574_I1.digitalRead(P1);
 uint8_t val3 = pcf8574_I1.digitalRead(P2);
 uint8_t val4 = pcf8574_I1.digitalRead(P3);
 uint8_t val5 = pcf8574_I1.digitalRead(P4);
 uint8_t val6 = pcf8574_I1.digitalRead(P5);
 uint8_t val7 = pcf8574_I1.digitalRead(P6);
 uint8_t val8 = pcf8574_I1.digitalRead(P7);

 uint8_t val9 = pcf8574_I2.digitalRead(P0);
 uint8_t val10 = pcf8574_I2.digitalRead(P1);
 uint8_t val11 = pcf8574_I2.digitalRead(P2);
 uint8_t val12 = pcf8574_I2.digitalRead(P3);
 uint8_t val13 = pcf8574_I2.digitalRead(P4);
 uint8_t val14 = pcf8574_I2.digitalRead(P5);
 uint8_t val15 = pcf8574_I2.digitalRead(P6);
 uint8_t val16 = pcf8574_I2.digitalRead(P7);

//------------------------------------
 if (val1==LOW) pcf8574_R1.digitalWrite(P0, LOW); else pcf8574_R1.digitalWrite(P0, HIGH);
 if (val2==LOW) pcf8574_R1.digitalWrite(P1, LOW); else pcf8574_R1.digitalWrite(P1, HIGH);
 if (val3==LOW) pcf8574_R1.digitalWrite(P2, LOW); else pcf8574_R1.digitalWrite(P2, HIGH);
 if (val4==LOW) pcf8574_R1.digitalWrite(P3, LOW); else pcf8574_R1.digitalWrite(P3, HIGH);
 if (val5==LOW) pcf8574_R1.digitalWrite(P4, LOW); else pcf8574_R1.digitalWrite(P4, HIGH);
 if (val6==LOW) pcf8574_R1.digitalWrite(P5, LOW); else pcf8574_R1.digitalWrite(P5, HIGH);
 if (val7==LOW) pcf8574_R1.digitalWrite(P6, LOW); else pcf8574_R1.digitalWrite(P6, HIGH);
 if (val8==LOW) pcf8574_R1.digitalWrite(P7, LOW); else pcf8574_R1.digitalWrite(P7, HIGH);

 if (val9==LOW) pcf8574_R2.digitalWrite(P0, LOW); else pcf8574_R2.digitalWrite(P0, HIGH);
 if (val10==LOW) pcf8574_R2.digitalWrite(P1, LOW); else pcf8574_R2.digitalWrite(P1, HIGH);
 if (val11==LOW) pcf8574_R2.digitalWrite(P2, LOW); else pcf8574_R2.digitalWrite(P2, HIGH);
 if (val12==LOW) pcf8574_R2.digitalWrite(P3, LOW); else pcf8574_R2.digitalWrite(P3, HIGH);
 if (val13==LOW) pcf8574_R2.digitalWrite(P4, LOW); else pcf8574_R2.digitalWrite(P4, HIGH);
 if (val14==LOW) pcf8574_R2.digitalWrite(P5, LOW); else pcf8574_R2.digitalWrite(P5, HIGH);
 if (val15==LOW) pcf8574_R2.digitalWrite(P6, LOW); else pcf8574_R2.digitalWrite(P6, HIGH);
 if (val16==LOW) pcf8574_R2.digitalWrite(P7, LOW); else pcf8574_R2.digitalWrite(P7, HIGH);

  // Delay for 500 milliseconds
  delay(50);
}
