// https://github.com/junkfix/esp32-ds18b20

#include "OneWireESP32.h"
const uint8_t MaxDevs = 1;
float currTemp[MaxDevs];

void tempTask(void *pvParameters){
	OneWire32 ds1(47); //gpio pin
	OneWire32 ds2(48); //gpio pin
  OneWire32 ds3(38); //gpio pin

	uint64_t addr1[MaxDevs];
  uint64_t addr2[MaxDevs];
  uint64_t addr3[MaxDevs];
	
	//uint64_t addr[] = {
	//	0x183c01f09506f428,
	//	0xf33c01e07683de28,
	//};
	
	//to find addresses
	uint8_t devices1 = ds1.search(addr1, MaxDevs);
	for (uint8_t i = 0; i < devices1; i += 1) {
		Serial.printf("T1: 0x%llx,\n", i, addr1[i]);
		//char buf[20]; snprintf( buf, 20, "0x%llx,", addr[i] ); Serial.println(buf);
	}

	uint8_t devices2 = ds2.search(addr2, MaxDevs);
	for (uint8_t i = 0; i < devices2; i += 1) {
		Serial.printf("T2: 0x%llx,\n", i, addr2[i]);
		//char buf[20]; snprintf( buf, 20, "0x%llx,", addr[i] ); Serial.println(buf);
	}

	uint8_t devices3 = ds3.search(addr3, MaxDevs);
	for (uint8_t i = 0; i < devices3; i += 1) {
		Serial.printf("T3: 0x%llx,\n", i, addr3[i]);
		//char buf[20]; snprintf( buf, 20, "0x%llx,", addr[i] ); Serial.println(buf);
	}
	//end

	for(;;){
		ds1.request();
    ds2.request();
    ds3.request();
		vTaskDelay(750 / portTICK_PERIOD_MS);
		for(byte i = 0; i < MaxDevs; i++){
			uint8_t err = ds1.getTemp(addr1[i], currTemp[i]);
			if(err){
				const char *errt[] = {"", "CRC", "BAD","DC","DRV"};
				Serial.print(i); Serial.print(": "); Serial.println(errt[err]);
			}else{
				Serial.print("T1"); Serial.print(": "); Serial.println(currTemp[i]);
			}
		}

		for(byte i = 0; i < MaxDevs; i++){
			uint8_t err = ds2.getTemp(addr2[i], currTemp[i]);
			if(err){
				const char *errt[] = {"", "CRC", "BAD","DC","DRV"};
				Serial.print(i); Serial.print(": "); Serial.println(errt[err]);
			}else{
				Serial.print("T2"); Serial.print(": "); Serial.println(currTemp[i]);
			}
		}

		for(byte i = 0; i < MaxDevs; i++){
			uint8_t err = ds3.getTemp(addr3[i], currTemp[i]);
			if(err){
				const char *errt[] = {"", "CRC", "BAD","DC","DRV"};
				Serial.print(i); Serial.print(": "); Serial.println(errt[err]);
			}else{
				Serial.print("T3"); Serial.print(": "); Serial.println(currTemp[i]);
			}
		}

		vTaskDelay(3000 / portTICK_PERIOD_MS);
	}
} // tempTask

void setup() {
	delay(1000);
	Serial.begin(115200);
	xTaskCreatePinnedToCore(tempTask, "tempTask", 4096,  NULL,  1,  NULL, 0);
}


void loop() {}