/**
 * @brief Simple example to control two relays using ESP32
 * @details This program demonstrates how to control two relays connected to GPIO40 and GPIO39
 *          of an ESP32 development board.
 *
 * Made by KinCony IoT: https://www.kincony.com
 */

// Define the GPIO pins for the relays
#define RELAY1_PIN 40  // GPIO40 for Relay 1
#define RELAY2_PIN 39  // GPIO39 for Relay 2

void setup() {
    // Initialize the serial communication for debugging
    Serial.begin(115200);
    Serial.println("ESP32 Relay Control Example");

    // Set the relay pins as output
    pinMode(RELAY1_PIN, OUTPUT);
    pinMode(RELAY2_PIN, OUTPUT);

    // Turn off both relays at startup (assuming active LOW relays)
    digitalWrite(RELAY1_PIN, HIGH);
    digitalWrite(RELAY2_PIN, HIGH);
}

void loop() {
    Serial.println("Turning ON Relay 1");
    digitalWrite(RELAY1_PIN, LOW); // Activate relay 1
    delay(1000); // Wait for 1 second
    
    Serial.println("Turning OFF Relay 1");
    digitalWrite(RELAY1_PIN, HIGH); // Deactivate relay 1
    delay(1000);
    
    Serial.println("Turning ON Relay 2");
    digitalWrite(RELAY2_PIN, LOW); // Activate relay 2
    delay(1000);
    
    Serial.println("Turning OFF Relay 2");
    digitalWrite(RELAY2_PIN, HIGH); // Deactivate relay 2
    delay(1000);
}
